"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fromAPItoLensState = fromAPItoLensState;
exports.fromLensStateToAPI = fromLensStateToAPI;
var _lensCommon = require("@kbn/lens-common");
var _types = require("../../types");
var _utils = require("../utils");
var _esql_column = require("../columns/esql_column");
var _coloring = require("../coloring");
var _metric = require("../columns/metric");
var _buckets = require("../columns/buckets");
var _utils2 = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const ACCESSOR = 'tagcloud_accessor';
function getAccessorName(type) {
  return `${ACCESSOR}_${type}`;
}
function buildVisualizationState(config) {
  var _layer$font_size$max, _layer$font_size, _layer$font_size$min, _layer$font_size2, _layer$metric$show_me, _layer$metric;
  const layer = config;
  return {
    layerId: _types.DEFAULT_LAYER_ID,
    valueAccessor: getAccessorName('metric'),
    orientation: layer.orientation ? layer.orientation === 'horizontal' ? _lensCommon.TAGCLOUD_ORIENTATION.SINGLE : layer.orientation === 'vertical' ? _lensCommon.TAGCLOUD_ORIENTATION.RIGHT_ANGLED : _lensCommon.TAGCLOUD_ORIENTATION.MULTIPLE : _lensCommon.LENS_TAGCLOUD_DEFAULT_STATE.orientation,
    maxFontSize: (_layer$font_size$max = (_layer$font_size = layer.font_size) === null || _layer$font_size === void 0 ? void 0 : _layer$font_size.max) !== null && _layer$font_size$max !== void 0 ? _layer$font_size$max : _lensCommon.LENS_TAGCLOUD_DEFAULT_STATE.maxFontSize,
    minFontSize: (_layer$font_size$min = (_layer$font_size2 = layer.font_size) === null || _layer$font_size2 === void 0 ? void 0 : _layer$font_size2.min) !== null && _layer$font_size$min !== void 0 ? _layer$font_size$min : _lensCommon.LENS_TAGCLOUD_DEFAULT_STATE.minFontSize,
    showLabel: (_layer$metric$show_me = (_layer$metric = layer.metric) === null || _layer$metric === void 0 ? void 0 : _layer$metric.show_metric_label) !== null && _layer$metric$show_me !== void 0 ? _layer$metric$show_me : _lensCommon.LENS_TAGCLOUD_DEFAULT_STATE.showLabel,
    tagAccessor: getAccessorName('tag'),
    ...(layer.tag_by.color ? {
      colorMapping: (0, _coloring.fromColorMappingAPIToLensState)(layer.tag_by.color)
    } : {})
  };
}
function getTagcloudDataset(layer, adHocDataViews, references, adhocReferences = [], layerId) {
  const dataset = (0, _utils.buildDatasetState)(layer, adHocDataViews, references, adhocReferences, layerId);
  if (!dataset || dataset.type == null) {
    throw new Error('Unsupported dataset type');
  }
  return dataset;
}
function getTagcloudMetric(layer, visualization) {
  if (!visualization.valueAccessor) return undefined;
  return {
    ...((0, _utils.isTextBasedLayer)(layer) ? (0, _esql_column.getValueApiColumn)(visualization.valueAccessor, layer) : (0, _utils.operationFromColumn)(visualization.valueAccessor, layer)),
    show_metric_label: visualization.showLabel
  };
}
function getTagcloudTagBy(layer, visualization) {
  if (!visualization.tagAccessor) return undefined;
  const colorMapping = (0, _coloring.fromColorMappingLensStateToAPI)(visualization.colorMapping);
  return {
    ...((0, _utils.isTextBasedLayer)(layer) ? (0, _esql_column.getValueApiColumn)(visualization.tagAccessor, layer) : (0, _utils.operationFromColumn)(visualization.tagAccessor, layer)),
    ...(colorMapping ? {
      color: colorMapping
    } : {})
  };
}
function reverseBuildVisualizationState(visualization, layer, layerId, adHocDataViews, references, adhocReferences) {
  const dataset = getTagcloudDataset(layer, adHocDataViews, references, adhocReferences, layerId);
  const metric = getTagcloudMetric(layer, visualization);
  const tagBy = getTagcloudTagBy(layer, visualization);
  return {
    type: 'tagcloud',
    dataset,
    ...(0, _utils.generateApiLayer)(layer),
    ...(metric ? {
      metric
    } : {}),
    ...(tagBy ? {
      tag_by: tagBy
    } : {}),
    orientation: visualization.orientation === _lensCommon.TAGCLOUD_ORIENTATION.SINGLE ? 'horizontal' : visualization.orientation === _lensCommon.TAGCLOUD_ORIENTATION.MULTIPLE ? 'angled' : 'vertical',
    font_size: {
      min: visualization.minFontSize,
      max: visualization.maxFontSize
    }
  };
}
function buildFormBasedLayer(layer) {
  const columns = (0, _metric.fromMetricAPItoLensState)(layer.metric);
  const layers = (0, _utils.generateLayer)(_types.DEFAULT_LAYER_ID, layer);
  const defaultLayer = layers[_types.DEFAULT_LAYER_ID];
  (0, _utils.addLayerColumn)(defaultLayer, getAccessorName('metric'), columns);
  const breakdownColumn = (0, _buckets.fromBucketLensApiToLensState)(layer.tag_by, columns.map(col => ({
    column: col,
    id: getAccessorName('metric')
  })));
  (0, _utils.addLayerColumn)(defaultLayer, getAccessorName('tag'), breakdownColumn, true);
  return layers;
}
function getValueColumns(layer) {
  return [(0, _esql_column.getValueColumn)(getAccessorName('metric'), layer.metric.column, 'number'), (0, _esql_column.getValueColumn)(getAccessorName('tag'), layer.tag_by.column)];
}
function fromAPItoLensState(config) {
  var _regularDataViews$;
  const _buildDataLayer = (cfg, i) => buildFormBasedLayer(cfg);
  const {
    layers,
    usedDataviews
  } = (0, _utils.buildDatasourceStates)(config, _buildDataLayer, getValueColumns);
  const visualization = buildVisualizationState(config);
  const {
    adHocDataViews,
    internalReferences
  } = (0, _utils.getAdhocDataviews)(usedDataviews);
  const regularDataViews = Object.values(usedDataviews).filter(v => v.type === 'dataView');
  const references = regularDataViews.length ? (0, _utils.buildReferences)({
    [_types.DEFAULT_LAYER_ID]: (_regularDataViews$ = regularDataViews[0]) === null || _regularDataViews$ === void 0 ? void 0 : _regularDataViews$.id
  }) : [];
  return {
    visualizationType: 'lnsTagcloud',
    ...(0, _utils2.getSharedChartAPIToLensState)(config),
    references,
    state: {
      datasourceStates: layers,
      internalReferences,
      filters: [],
      query: {
        language: 'kuery',
        query: ''
      },
      visualization,
      adHocDataViews: config.dataset.type === 'index' ? adHocDataViews : {}
    }
  };
}
function fromLensStateToAPI(config) {
  var _ref, _ref2, _state$datasourceStat, _state$datasourceStat2, _state$datasourceStat3, _state$datasourceStat4, _config$state$adHocDa;
  const {
    state
  } = config;
  const visualization = state.visualization;
  const layers = (_ref = (_ref2 = (_state$datasourceStat = (_state$datasourceStat2 = state.datasourceStates.formBased) === null || _state$datasourceStat2 === void 0 ? void 0 : _state$datasourceStat2.layers) !== null && _state$datasourceStat !== void 0 ? _state$datasourceStat : (_state$datasourceStat3 = state.datasourceStates.textBased) === null || _state$datasourceStat3 === void 0 ? void 0 : _state$datasourceStat3.layers) !== null && _ref2 !== void 0 ? _ref2 : // @ts-expect-error unfortunately due to a migration bug, some existing SO might still have the old indexpattern DS state
  (_state$datasourceStat4 = state.datasourceStates.indexpattern) === null || _state$datasourceStat4 === void 0 ? void 0 : _state$datasourceStat4.layers) !== null && _ref !== void 0 ? _ref : [];

  // Necessary for ESQL panels to find the correct layer, since the old layers are not removed from the state
  const visLayerId = Object.entries(layers).find(([id]) => id === visualization.layerId);
  const [layerId, layer] = visLayerId !== null && visLayerId !== void 0 ? visLayerId : Object.entries(layers)[0];
  const visualizationState = {
    ...(0, _utils2.getSharedChartLensStateToAPI)(config),
    ...reverseBuildVisualizationState(visualization, layer, layerId !== null && layerId !== void 0 ? layerId : _types.DEFAULT_LAYER_ID, (_config$state$adHocDa = config.state.adHocDataViews) !== null && _config$state$adHocDa !== void 0 ? _config$state$adHocDa : {}, config.references, config.state.internalReferences)
  };
  return visualizationState;
}