"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.visualizationTypes = exports.visualizationSubtypes = exports.YAxisModes = exports.SeriesTypes = void 0;
var _i18n = require("@kbn/i18n");
var _chartIcons = require("@kbn/chart-icons");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const YAxisModes = exports.YAxisModes = {
  AUTO: 'auto',
  LEFT: 'left',
  RIGHT: 'right',
  BOTTOM: 'bottom'
};
const SeriesTypes = exports.SeriesTypes = {
  BAR: 'bar',
  LINE: 'line',
  AREA: 'area',
  BAR_STACKED: 'bar_stacked',
  AREA_STACKED: 'area_stacked',
  BAR_HORIZONTAL: 'bar_horizontal',
  BAR_PERCENTAGE_STACKED: 'bar_percentage_stacked',
  BAR_HORIZONTAL_STACKED: 'bar_horizontal_stacked',
  AREA_PERCENTAGE_STACKED: 'area_percentage_stacked',
  BAR_HORIZONTAL_PERCENTAGE_STACKED: 'bar_horizontal_percentage_stacked'
};
const barShared = {
  sortPriority: 1,
  description: _i18n.i18n.translate('xpack.lens.bar.visualizationDescription', {
    defaultMessage: 'Compare categories or groups of data with bars.'
  })
};
const areaShared = {
  sortPriority: 3,
  description: _i18n.i18n.translate('xpack.lens.area.visualizationDescription', {
    defaultMessage: 'Compare distributions of cumulative data trends.'
  })
};
const lineShared = {
  id: 'line',
  icon: _chartIcons.IconChartLine,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.lineLabel', {
    defaultMessage: 'Line'
  }),
  sortPriority: 2,
  description: _i18n.i18n.translate('xpack.lens.line.visualizationDescription', {
    defaultMessage: 'Reveal variations in data over time.'
  })
};
const visualizationSubtypes = exports.visualizationSubtypes = [{
  id: 'bar',
  icon: _chartIcons.IconChartBar,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.barLabel', {
    defaultMessage: 'Bar vertical'
  }),
  ...barShared
}, {
  id: 'bar_horizontal',
  icon: _chartIcons.IconChartBarHorizontal,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.barHorizontalLabel', {
    defaultMessage: 'H. Bar'
  }),
  fullLabel: _i18n.i18n.translate('xpack.lens.xyVisualization.barHorizontalFullLabel', {
    defaultMessage: 'Bar horizontal'
  }),
  ...barShared
}, {
  id: 'bar_stacked',
  icon: _chartIcons.IconChartBarStacked,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.stackedBarLabel', {
    defaultMessage: 'Bar vertical stacked'
  }),
  ...barShared
}, {
  id: 'bar_percentage_stacked',
  icon: _chartIcons.IconChartBarPercentage,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.stackedPercentageBarLabel', {
    defaultMessage: 'Bar vertical percentage'
  }),
  ...barShared
}, {
  id: 'bar_horizontal_stacked',
  icon: _chartIcons.IconChartBarHorizontalStacked,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.stackedBarHorizontalLabel', {
    defaultMessage: 'H. Stacked bar'
  }),
  fullLabel: _i18n.i18n.translate('xpack.lens.xyVisualization.stackedBarHorizontalFullLabel', {
    defaultMessage: 'Bar horizontal stacked'
  }),
  ...barShared
}, {
  id: 'bar_horizontal_percentage_stacked',
  icon: _chartIcons.IconChartBarHorizontalPercentage,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.stackedPercentageBarHorizontalLabel', {
    defaultMessage: 'H. Percentage bar'
  }),
  fullLabel: _i18n.i18n.translate('xpack.lens.xyVisualization.stackedPercentageBarHorizontalFullLabel', {
    defaultMessage: 'Bar horizontal percentage'
  }),
  ...barShared
}, {
  id: 'area',
  icon: _chartIcons.IconChartArea,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.areaLabel', {
    defaultMessage: 'Area'
  }),
  ...areaShared
}, {
  id: 'area_stacked',
  icon: _chartIcons.IconChartAreaStacked,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.stackedAreaLabel', {
    defaultMessage: 'Area stacked'
  }),
  ...areaShared
}, {
  id: 'area_percentage_stacked',
  icon: _chartIcons.IconChartAreaPercentage,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.stackedPercentageAreaLabel', {
    defaultMessage: 'Area percentage'
  }),
  ...areaShared
}, lineShared];
const visualizationTypes = exports.visualizationTypes = [{
  id: 'bar',
  subtypes: ['bar', 'bar_stacked', 'bar_percentage_stacked', 'bar_horizontal', 'bar_horizontal_stacked', 'bar_horizontal_percentage_stacked'],
  icon: _chartIcons.IconChartBar,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.barLabel', {
    defaultMessage: 'Bar'
  }),
  ...barShared,
  getCompatibleSubtype: seriesType => {
    if (seriesType === 'area') {
      return 'bar';
    } else if (seriesType === 'area_stacked') {
      return 'bar_stacked';
    } else if (seriesType === 'area_percentage_stacked') {
      return 'bar_percentage_stacked';
    }
  }
}, {
  id: 'area',
  icon: _chartIcons.IconChartArea,
  label: _i18n.i18n.translate('xpack.lens.xyVisualization.areaLabel', {
    defaultMessage: 'Area'
  }),
  sortPriority: 3,
  description: _i18n.i18n.translate('xpack.lens.area.visualizationDescription', {
    defaultMessage: 'Compare distributions of cumulative data trends.'
  }),
  subtypes: ['area', 'area_stacked', 'area_percentage_stacked'],
  getCompatibleSubtype: seriesType => {
    if (seriesType === 'bar') {
      return 'area';
    } else if (seriesType === 'bar_stacked') {
      return 'area_stacked';
    } else if (seriesType === 'bar_percentage_stacked') {
      return 'area_percentage_stacked';
    }
  }
}, {
  ...lineShared,
  subtypes: ['line']
}];