"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.METRIC_TRENDLINE_NAME = exports.LENS_METRIC_STATE_DEFAULTS = exports.LENS_METRIC_SECONDARY_DEFAULT_STATIC_COLOR = exports.LENS_METRIC_SECONDARY_BASELINE_DEFAULT_VALUE = exports.LENS_METRIC_LABEL_POSITION = exports.LENS_METRIC_ID = exports.LENS_METRIC_GROUP_ID = exports.LENS_METRIC_DEFAULT_TRENDLINE_NAME = exports.LENS_METRIC_BREAKDOWN_DEFAULT_MAX_COLUMNS = exports.LENS_METRIC_AVAILABLE_METRIC_ICONS = exports.EXPRESSION_METRIC_TRENDLINE_NAME = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const LENS_METRIC_ID = exports.LENS_METRIC_ID = 'lnsMetric';
const LENS_METRIC_GROUP_ID = exports.LENS_METRIC_GROUP_ID = {
  METRIC: 'metric',
  SECONDARY_METRIC: 'secondaryMetric',
  MAX: 'max',
  BREAKDOWN_BY: 'breakdownBy',
  TREND_METRIC: 'trendMetric',
  TREND_SECONDARY_METRIC: 'trendSecondaryMetric',
  TREND_TIME: 'trendTime',
  TREND_BREAKDOWN_BY: 'trendBreakdownBy'
};

/**
 * Defaults for select optional Metric vis state options
 */
const LENS_METRIC_STATE_DEFAULTS = exports.LENS_METRIC_STATE_DEFAULTS = {
  titlesTextAlign: 'left',
  valuesTextAlign: 'right',
  iconAlign: 'left',
  valueFontMode: 'default'
};
const LENS_METRIC_SECONDARY_DEFAULT_STATIC_COLOR = exports.LENS_METRIC_SECONDARY_DEFAULT_STATIC_COLOR = '#E4E8F1';
const LENS_METRIC_DEFAULT_TRENDLINE_NAME = exports.LENS_METRIC_DEFAULT_TRENDLINE_NAME = 'default';
const METRIC_TRENDLINE_NAME = exports.METRIC_TRENDLINE_NAME = 'metricTrendline';
const LENS_METRIC_LABEL_POSITION = exports.LENS_METRIC_LABEL_POSITION = {
  BOTTOM: 'bottom',
  TOP: 'top'
};
const LENS_METRIC_SECONDARY_BASELINE_DEFAULT_VALUE = exports.LENS_METRIC_SECONDARY_BASELINE_DEFAULT_VALUE = 0;
const LENS_METRIC_BREAKDOWN_DEFAULT_MAX_COLUMNS = exports.LENS_METRIC_BREAKDOWN_DEFAULT_MAX_COLUMNS = 3;
const LENS_METRIC_AVAILABLE_METRIC_ICONS = exports.LENS_METRIC_AVAILABLE_METRIC_ICONS = {
  EMPTY: 'empty',
  SORTUP: 'sortUp',
  SORTDOWN: 'sortDown',
  COMPUTE: 'compute',
  ASTERISK: 'asterisk',
  ALERT: 'alert',
  BELL: 'bell',
  BOLT: 'bolt',
  BUG: 'bug',
  EDITOR_COMMENT: 'editorComment',
  FLAG: 'flag',
  HEART: 'heart',
  MAP_MARKER: 'mapMarker',
  PIN: 'pin',
  STAR_EMPTY: 'starEmpty',
  TAG: 'tag',
  GLOBE: 'globe',
  TEMPERATURE: 'temperature'
};
const EXPRESSION_METRIC_TRENDLINE_NAME = exports.EXPRESSION_METRIC_TRENDLINE_NAME = 'metricTrendline';