"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionButtons = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/private/inspect_component/public/components/inspect/flyout/actions_section/action_buttons.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const ActionButtons = ({
  fileName,
  lineNumber,
  columnNumber,
  relativePath,
  branch
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const CURSOR_LINK = `cursor://file/${fileName}:${lineNumber}:${columnNumber}`;
  const GITHUB_DEV_LINK = `https://github.dev/elastic/kibana/blob/${branch}/${relativePath}#L${lineNumber}`;
  const GITHUB_LINK = `https://github.com/elastic/kibana/blob/${branch}/${relativePath}#L${lineNumber}`;
  const VSCODE_LINK = `vscode://file/${fileName}:${lineNumber}:${columnNumber}`;
  const WEBSTORM_LINK = `webstorm://open?file=/${fileName}&line=${lineNumber}&column=${columnNumber}`;
  const ACTIONS = [{
    href: GITHUB_LINK,
    i18nId: 'kbnInspectComponent.inspectFlyout.actionsSection.openOnGitHubButtonText',
    icon: 'logoGithub',
    id: 'github',
    label: 'GitHub'
  }, {
    href: GITHUB_DEV_LINK,
    i18nId: 'kbnInspectComponent.inspectFlyout.actionsSection.openOnGitHubDevButtonText',
    icon: 'logoGithub',
    id: 'githubDev',
    label: 'GitHub.dev'
  }, {
    href: VSCODE_LINK,
    i18nId: 'kbnInspectComponent.inspectFlyout.actionsSection.openInVSCodeButtonText',
    icon: 'code',
    id: 'vscode',
    label: 'VSCode'
  }, {
    i18nId: 'kbnInspectComponent.inspectFlyout.actionsSection.openInWebStormButtonText',
    href: WEBSTORM_LINK,
    icon: 'code',
    id: 'webstorm',
    label: 'WebStorm'
  }, {
    href: CURSOR_LINK,
    i18nId: 'kbnInspectComponent.inspectFlyout.actionsSection.openInCursorButtonText',
    icon: 'code',
    id: 'cursor',
    label: 'Cursor'
  }];
  const iconCss = (0, _react2.css)`
    margin-block-end: ${euiTheme.size.s};
  `;
  const titleCss = (0, _react2.css)`
    font-weight: ${euiTheme.font.weight.bold};
  `;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    wrap: true,
    "data-test-subj": "inspectComponentActionButtons",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, ACTIONS.map(({
    href,
    icon,
    id,
    i18nId,
    label
  }, index) => {
    const isLastOdd = index === ACTIONS.length - 1 && ACTIONS.length % 2 !== 0;
    const cardCss = (0, _react2.css)({
      [`@media (min-width: ${euiTheme.breakpoint.m}px)`]: {
        flex: `0 1 calc(50% - ${euiTheme.size.m})`,
        maxWidth: `calc(50% - ${euiTheme.size.m})`,
        ...(isLastOdd && {
          marginLeft: 'auto',
          marginRight: 'auto'
        })
      }
    });
    const ariaLabel = _i18n.i18n.translate('kbnInspectComponent.inspectFlyout.actionsSection.openFileInAriaLabel', {
      defaultMessage: 'Open file using {target}',
      values: {
        target: label
      }
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      "data-test-subj": `inspectComponentActionButton-${id}`,
      key: id,
      "aria-label": ariaLabel,
      href: href,
      css: cardCss,
      layout: "vertical",
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: icon,
        size: "xxl",
        css: iconCss,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 130,
          columnNumber: 19
        }
      }),
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: euiTheme.colors.textPrimary,
        component: "span",
        css: titleCss,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: i18nId,
        defaultMessage: label,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 17
        }
      })),
      titleSize: "s",
      target: "_blank",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 11
      }
    });
  }));
};
exports.ActionButtons = ActionButtons;