"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineTreeNodeLabel = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/packages/shared/ingest-pipelines/src/components/pipeline_structure_tree/tree_node_labels/pipeline_tree_node_label.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const MAX_PIPELINE_NAME_LENGTH = 40;
const PipelineTreeNodeLabel = ({
  pipelineName,
  isManaged,
  isDeprecated,
  isSelected,
  onClick,
  level
}) => {
  const maxCharacters = MAX_PIPELINE_NAME_LENGTH - level * 4;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    css: {
      width: '100%',
      minWidth: `${360 - level * 25}px`,
      position: 'relative'
    },
    alignItems: "center",
    justifyContent: "center",
    "data-test-subj": `pipelineTreeNode-${pipelineName}`,
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    onClick: e => {
      e.stopPropagation();
      onClick();
    },
    size: "s",
    textAlign: "left",
    "data-test-subj": `pipelineTreeNode-${pipelineName}-link`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 9
    }
  }, pipelineName.length > maxCharacters ? `${pipelineName.slice(0, maxCharacters)}...` : pipelineName)), (isManaged || isDeprecated) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    responsive: false,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, isManaged && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": `pipelineTreeNode-${pipelineName}-managedIcon`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('ingestPipelines.pipelineStructureTree.treeNodeManagedTooltip', {
      defaultMessage: 'Managed'
    }),
    type: "lock",
    color: isSelected ? 'primary' : 'subdued',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 17
    }
  })), isDeprecated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": `pipelineTreeNode-${pipelineName}-deprecatedIcon`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('ingestPipelines.pipelineStructureTree.treeNodeDeprecatedTooltip', {
      defaultMessage: 'Deprecated'
    }),
    type: "warning",
    color: isSelected ? 'primary' : 'subdued',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 17
    }
  })))));
};
exports.PipelineTreeNodeLabel = PipelineTreeNodeLabel;