"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Foreach = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../../shared_imports");
var _field_components = require("../field_components");
var _field_name_field = require("./common_fields/field_name_field");
var _shared = require("./shared");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ingest_pipelines/public/application/components/pipeline_editor/components/processor_form/processors/foreach.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  emptyField
} = _shared_imports.fieldValidators;
const fieldsConfig = {
  /* Required fields config */
  processor: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    deserializer: _shared.to.xJsonString,
    serializer: _shared.from.optionalXJson,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.foreachForm.processorFieldLabel', {
      defaultMessage: 'Processor'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.foreachForm.processorHelpText', {
      defaultMessage: 'Ingest processor to run on each array value.'
    }),
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.foreachForm.processorRequiredError', {
        defaultMessage: 'A processor is required.'
      }))
    }, {
      validator: (0, _shared.isXJsonField)(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.foreachForm.processorInvalidJsonError', {
        defaultMessage: 'Invalid JSON'
      }))
    }]
  }
};
const Foreach = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.failForm.fieldNameHelpText', {
      defaultMessage: 'Field containing array values.'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _field_components.XJsonEditor,
    componentProps: {
      editorProps: {
        'data-test-subj': 'processorField',
        height: _shared.EDITOR_PX_HEIGHT.medium,
        'aria-label': _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.foreachForm.optionsFieldAriaLabel', {
          defaultMessage: 'Configuration JSON editor'
        })
      }
    },
    config: fieldsConfig.processor,
    path: "fields.processor",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 7
    }
  }));
};
exports.Foreach = Foreach;