"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogEntryCategoriesPageContent = exports.CategoriesPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/logs-shared-plugin/public");
var _log_analysis = require("../../../../common/log_analysis");
var _loading_page = require("../../../components/loading_page");
var _log_analysis_setup = require("../../../components/logging/log_analysis_setup");
var _setup_flyout = require("../../../components/logging/log_analysis_setup/setup_flyout");
var _log_analysis2 = require("../../../containers/logs/log_analysis");
var _log_entry_categories = require("../../../containers/logs/log_analysis/modules/log_entry_categories");
var _page_template = require("../shared/page_template");
var _page_results_content = require("./page_results_content");
var _page_setup_content = require("./page_setup_content");
var _use_log_ml_job_id_formats_shim = require("../shared/use_log_ml_job_id_formats_shim");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/pages/logs/log_entry_categories/page_content.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const logCategoriesTitle = _i18n.i18n.translate('xpack.infra.logs.logCategoriesTitle', {
  defaultMessage: 'Categories'
});
const LogEntryCategoriesPageContent = () => {
  const {
    hasLogAnalysisReadCapabilities,
    hasLogAnalysisSetupCapabilities
  } = (0, _log_analysis2.useLogAnalysisCapabilitiesContext)();
  const {
    fetchJobStatus,
    setupStatus,
    jobStatus
  } = (0, _log_entry_categories.useLogEntryCategoriesModuleContext)();
  const {
    showModuleSetup
  } = (0, _setup_flyout.useLogAnalysisSetupFlyoutStateContext)();
  const showCategoriesModuleSetup = (0, _react.useCallback)(() => showModuleSetup('logs_ui_categories'), [showModuleSetup]);
  (0, _react.useEffect)(() => {
    if (hasLogAnalysisReadCapabilities) {
      fetchJobStatus();
    }
  }, [fetchJobStatus, hasLogAnalysisReadCapabilities]);
  const {
    idFormats
  } = (0, _use_log_ml_job_id_formats_shim.useLogMlJobIdFormatsShimContext)();
  if (setupStatus.type === 'initializing') {
    return /*#__PURE__*/_react.default.createElement(_loading_page.LoadingPage, {
      message: _i18n.i18n.translate('xpack.infra.logs.logEntryCategories.jobStatusLoadingMessage', {
        defaultMessage: 'Checking status of categorization jobs...'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 7
      }
    });
  } else if (setupStatus.type === 'unknown') {
    return /*#__PURE__*/_react.default.createElement(CategoriesPageTemplate, {
      isEmptyState: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_log_analysis_setup.LogAnalysisSetupStatusUnknownPrompt, {
      retry: fetchJobStatus,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 64,
        columnNumber: 9
      }
    }));
  } else if ((0, _log_analysis.isJobStatusWithResults)(jobStatus[_log_analysis.logEntryCategoriesJobType])) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_results_content.LogEntryCategoriesResultsContent, {
      onOpenSetup: showCategoriesModuleSetup,
      pageTitle: logCategoriesTitle,
      idFormat: idFormats[_log_analysis.logEntryCategoriesJobType],
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_setup_flyout.LogAnalysisSetupFlyout, {
      allowedModules: allowedSetupModules,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 9
      }
    }));
  } else if (!hasLogAnalysisSetupCapabilities) {
    return /*#__PURE__*/_react.default.createElement(CategoriesPageTemplate, {
      isEmptyState: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_log_analysis_setup.MissingSetupPrivilegesPrompt, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 9
      }
    }));
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(CategoriesPageTemplate, {
      isEmptyState: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_page_setup_content.LogEntryCategoriesSetupContent, {
      onOpenSetup: showCategoriesModuleSetup,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_setup_flyout.LogAnalysisSetupFlyout, {
      allowedModules: allowedSetupModules,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 9
      }
    }));
  }
};
exports.LogEntryCategoriesPageContent = LogEntryCategoriesPageContent;
const allowedSetupModules = ['logs_ui_categories'];
const CategoriesPageTemplate = ({
  children,
  ...rest
}) => {
  const {
    logViewStatus
  } = (0, _public.useLogViewContext)();
  return /*#__PURE__*/_react.default.createElement(_page_template.LogsPageTemplate, (0, _extends2.default)({
    hasData: (logViewStatus === null || logViewStatus === void 0 ? void 0 : logViewStatus.index) !== 'missing',
    "data-test-subj": "logsLogEntryCategoriesPage",
    pageHeader: rest.isEmptyState ? undefined : {
      pageTitle: logCategoriesTitle
    }
  }, rest, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }), children);
};
exports.CategoriesPageTemplate = CategoriesPageTemplate;