"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SwitchSchemaMessage = SwitchSchemaMessage;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/shared/switch_schema_message.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function SwitchSchemaMessage({
  dataTestSubj
}) {
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.waffle.noDataInSelectedSchemaTitle",
    defaultMessage: "{switchSchema} to view hosts matching another schema.",
    values: {
      switchSchema: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": dataTestSubj,
        target: "_blank",
        href: _constants.SCHEMA_SELECTOR_DOCS_LINK,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 20,
          columnNumber: 11
        }
      }, _i18n.i18n.translate('xpack.infra.waffle.switchSchemaDocsLink', {
        defaultMessage: 'Switch schema'
      }))
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 15,
      columnNumber: 5
    }
  });
}