"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalysisSetupIndicesForm = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_kibana = require("../../../../hooks/use_kibana");
var _loading_overlay_wrapper = require("../../../loading_overlay_wrapper");
var _index_setup_row = require("./index_setup_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/logging/log_analysis_setup/initial_configuration_step/analysis_setup_indices_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getKibanaAdvancedSettingsHref(application) {
  return application.getUrlForApp('management', {
    path: `/kibana/settings?query=${encodeURIComponent('Log sources')}`
  });
}
const AnalysisSetupIndicesForm = ({
  disabled = false,
  indices,
  isValidating,
  onChangeSelectedIndices,
  previousQualityWarnings = [],
  validationErrors = []
}) => {
  const {
    services: {
      application
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const advancedSettingsHref = (0, _react.useMemo)(() => getKibanaAdvancedSettingsHref(application), [application]);
  const changeIsIndexSelected = (0, _react.useCallback)((indexName, isSelected) => {
    onChangeSelectedIndices(indices.map(index => {
      return index.name === indexName ? {
        ...index,
        isSelected
      } : index;
    }));
  }, [indices, onChangeSelectedIndices]);
  const changeDatasetFilter = (0, _react.useCallback)((indexName, datasetFilter) => {
    onChangeSelectedIndices(indices.map(index => {
      return index.name === indexName ? {
        ...index,
        datasetFilter
      } : index;
    }));
  }, [indices, onChangeSelectedIndices]);
  const isInvalid = validationErrors.length > 0;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.indicesSelectionTitle",
    defaultMessage: "Choose indices",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.analysisSetup.indicesSelectionDescription",
    defaultMessage: "By default, Machine Learning analyzes log messages in all log indices configured for the {advancedSettingsLink}. You can choose to only analyze a subset of the index names. Every selected index name must match at least one index with log entries. You can also choose to only include a certain subset of datasets. Note that the dataset filter applies to all selected indices.",
    values: {
      advancedSettingsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "xpack.infra.analysisSetup.logSourcesSettingLink",
        href: advancedSettingsHref,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.analysisSetup.logSourcesSettingLinkText",
        defaultMessage: "log sources setting",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 19
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_loading_overlay_wrapper.LoadingOverlayWrapper, {
    isLoading: isValidating,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    isInvalid: isInvalid,
    label: indicesSelectionLabel,
    labelType: "legend",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indices.map(index => /*#__PURE__*/_react.default.createElement(_index_setup_row.IndexSetupRow, {
    index: index,
    isDisabled: disabled,
    key: index.name,
    onChangeIsSelected: changeIsIndexSelected,
    onChangeDatasetFilter: changeDatasetFilter,
    previousQualityWarnings: previousQualityWarnings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 17
    }
  })))))));
};
exports.AnalysisSetupIndicesForm = AnalysisSetupIndicesForm;
const indicesSelectionLabel = _i18n.i18n.translate('xpack.infra.analysisSetup.indicesSelectionLabel', {
  defaultMessage: 'Indices'
});