"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CoreProviders = exports.CommonInfraProviders = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public2 = require("@kbn/observability-shared-plugin/public");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _hooks = require("@kbn/react-kibana-context-theme/hooks");
var _use_kibana = require("../hooks/use_kibana");
var _header_action_menu_provider = require("../containers/header_action_menu_provider");
var _triggers_actions_context = require("../containers/triggers_actions_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/apps/common_providers.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CommonInfraProviders = ({
  children,
  triggersActionsUI,
  setHeaderActionMenu,
  appName,
  storage,
  theme$
}) => {
  const darkMode = (0, _hooks.useKibanaIsDarkMode)();
  return /*#__PURE__*/_react.default.createElement(_triggers_actions_context.TriggersActionsProvider, {
    triggersActionsUI: triggersActionsUI,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: darkMode,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(DataUIProviders, {
    appName: appName,
    storage: storage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_header_action_menu_provider.HeaderActionMenuProvider, {
    setHeaderActionMenu: setHeaderActionMenu,
    theme$: theme$,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_public2.NavigationWarningPromptProvider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 13
    }
  }, children)))));
};
exports.CommonInfraProviders = CommonInfraProviders;
const CoreProviders = ({
  children,
  core,
  pluginStart,
  plugins,
  kibanaEnvironment
}) => {
  const KibanaContextProviderForPlugin = (0, _use_kibana.useKibanaContextForPluginProvider)(core, plugins, pluginStart);
  const KibanaEnvContextForPluginProvider = (0, _use_kibana.useKibanaEnvironmentContextProvider)(kibanaEnvironment);
  return /*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, core, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: {
      application: core.application
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(KibanaContextProviderForPlugin, {
    services: {
      ...core,
      ...plugins,
      ...pluginStart
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(KibanaEnvContextForPluginProvider, {
    kibanaEnv: kibanaEnvironment,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, children))));
};
exports.CoreProviders = CoreProviders;
const DataUIProviders = ({
  appName,
  children,
  storage
}) => /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
  services: {
    appName,
    storage
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 98,
    columnNumber: 3
  }
}, children);