"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.notificationService = exports.NotificationService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class NotificationService {
  constructor() {
    (0, _defineProperty2.default)(this, "_toasts", void 0);
    (0, _defineProperty2.default)(this, "addToasts", (title, type, text) => {
      this._toasts.add({
        title,
        color: type,
        text
      });
    });
  }
  setup(notifications) {
    this._toasts = notifications.toasts;
  }
  get toasts() {
    return this._toasts;
  }
  showDangerToast(title, text) {
    this.addToasts(title, 'danger', text);
  }
  showWarningToast(title, text) {
    this.addToasts(title, 'warning', text);
  }
  showSuccessToast(title, text) {
    this.addToasts(title, 'success', text);
  }
  showInfoToast(title, text) {
    this.addToasts(title, 'info', text);
  }
}
exports.NotificationService = NotificationService;
const notificationService = exports.notificationService = new NotificationService();