"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateStep = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _create_policy_context = require("../create_policy_context");
var _lib = require("../../../../../common/lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/enrich_policy_create/steps/create.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Beyond a certain point, highlighting the syntax will bog down performance to unacceptable
// levels. This way we prevent that happening for very large requests.
const getLanguageForQuery = query => query.length < 60000 ? 'json' : undefined;
const SummaryTab = ({
  policy
}) => {
  const queryAsString = policy.query ? JSON.stringify(policy.query, null, 2) : '';
  const language = getLanguageForQuery(queryAsString);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": "enrichPolicySummaryList",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 7
    }
  }, policy.name && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStep.nameLabel', {
    defaultMessage: 'Name'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "policyNameValue",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 13
    }
  }, policy.name)), policy.type && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStep.typeLabel', {
    defaultMessage: 'Type'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "policyTypeValue",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 13
    }
  }, policy.type)), policy.sourceIndices && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStep.sourceIndicesLabel', {
    defaultMessage: 'Source indices'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "policyIndicesValue",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 17
    }
  }, policy.sourceIndices.map(index => /*#__PURE__*/_react.default.createElement("li", {
    key: index,
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 21
    }
  }, index)))))), policy.matchField && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStep.matchFieldLabel', {
    defaultMessage: 'Match field'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "policyMatchFieldValue",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  }, policy.matchField)), policy.enrichFields && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStep.enrichFieldsLabel', {
    defaultMessage: 'Enrich fields'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    "data-test-subj": "policyEnrichFieldsValue",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("ul", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 17
    }
  }, policy.enrichFields.map(field => /*#__PURE__*/_react.default.createElement("li", {
    key: field,
    className: "eui-textBreakWord",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 21
    }
  }, field)))))), policy.query && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 130,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStep.queryLabel', {
    defaultMessage: 'Query'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: language,
    isCopyable: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 15
    }
  }, queryAsString)))));
};
const RequestTab = ({
  policy
}) => {
  const request = JSON.stringify((0, _lib.serializeAsESPolicy)(policy), null, 2);
  const language = getLanguageForQuery(request);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicyCreate.createStep.descriptionText",
    defaultMessage: "This request will create the following enrich policy.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    language: language,
    isCopyable: true,
    "data-test-subj": "requestBody",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  }, (0, _lib.getESPolicyCreationApiCall)(policy.name), `\n`, request));
};
const CREATE_AND_EXECUTE_POLICY = true;
const CreateStep = ({
  onBack,
  onSubmit,
  isLoading
}) => {
  const {
    draft
  } = (0, _create_policy_context.useCreatePolicyContext)();
  const summaryTabs = [{
    id: 'summary',
    name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStep.summaryTabLabel', {
      defaultMessage: 'Summary'
    }),
    'data-test-subj': 'summaryTab',
    content: /*#__PURE__*/_react.default.createElement(SummaryTab, {
      policy: draft,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 16
      }
    })
  }, {
    id: 'request',
    name: _i18n.i18n.translate('xpack.idxMgmt.enrichPolicyCreate.createStep.requestTabLabel', {
      defaultMessage: 'Request'
    }),
    'data-test-subj': 'requestTab',
    content: /*#__PURE__*/_react.default.createElement(RequestTab, {
      policy: draft,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 200,
        columnNumber: 16
      }
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    tabs: summaryTabs,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 208,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "creationStep",
    justifyContent: "spaceBetween",
    style: {
      maxWidth: 400
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 217,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    minWidth: false,
    color: "primary",
    iconSide: "left",
    iconType: "arrowLeft",
    "data-test-subj": "backButton",
    onClick: onBack,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicyCreate.createStep.backButtonLabel",
    defaultMessage: "Back",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 234,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    onClick: () => onSubmit(),
    isDisabled: isLoading,
    "data-test-subj": "createButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicyCreate.createStep.createButtonLabel",
    defaultMessage: "Create",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 15
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    color: "primary",
    onClick: () => onSubmit(CREATE_AND_EXECUTE_POLICY),
    isDisabled: isLoading,
    "data-test-subj": "createAndExecuteButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.enrichPolicyCreate.createStep.createAndExecuteButtonLabel",
    defaultMessage: "Create and execute",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 256,
      columnNumber: 15
    }
  }))))));
};
exports.CreateStep = CreateStep;