"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OtherTypeJsonParameter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../shared_imports");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/other_type_json_parameter.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const {
  isJsonField
} = _shared_imports.fieldValidators;

/**
 * This is a special component that does not have an explicit entry in {@link PARAMETERS_DEFINITION}.
 *
 * We use it to store custom defined parameters in a field called "otherTypeJson".
 */

const fieldConfig = {
  label: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.otherTypeJsonFieldLabel', {
    defaultMessage: 'Type Parameters JSON'
  }),
  defaultValue: {},
  validations: [{
    validator: isJsonField(_i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.validations.otherTypeJsonInvalidJSONErrorMessage', {
      defaultMessage: 'Invalid JSON.'
    }))
  }, {
    validator: ({
      value
    }) => {
      const json = JSON.parse(value);
      if (Array.isArray(json)) {
        return {
          message: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.validations.otherTypeJsonArrayNotAllowedErrorMessage', {
            defaultMessage: 'Arrays are not allowed.'
          })
        };
      }
    }
  }, {
    validator: ({
      value
    }) => {
      const json = JSON.parse(value);
      if (json.type) {
        return {
          code: 'ERR_CUSTOM_TYPE_OVERRIDDEN',
          message: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.parameters.validations.otherTypeJsonTypeFieldErrorMessage', {
            defaultMessage: 'Cannot override the "type" field.'
          })
        };
      }
    }
  }],
  deserializer: value => {
    if (value === '') {
      return value;
    }
    return JSON.stringify(value, null, 2);
  },
  serializer: value => {
    try {
      return JSON.parse(value);
    } catch (error) {
      // swallow error and return non-parsed value;
      return value;
    }
  }
};
const OtherTypeJsonParameter = () => /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
  path: "otherTypeJson",
  config: fieldConfig,
  component: _shared_imports.JsonEditorField,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 87,
    columnNumber: 3
  }
});
exports.OtherTypeJsonParameter = OtherTypeJsonParameter;