"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.retryLifecycleActionExtension = exports.removeLifecyclePolicyActionExtension = exports.ilmFilterExtension = exports.ilmBannerExtension = exports.addLifecyclePolicyActionExtension = exports.addAllExtensions = void 0;
var _react = _interopRequireDefault(require("react"));
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _api = require("../application/services/api");
var _index_lifecycle_summary = require("./components/index_lifecycle_summary");
var _add_lifecycle_confirm_modal = require("./components/add_lifecycle_confirm_modal");
var _remove_lifecycle_confirm_modal = require("./components/remove_lifecycle_confirm_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/extend_index_management/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const stepPath = 'ilm.step';
const retryLifecycleActionExtension = ({
  indices
}) => {
  const indicesWithFailedStep = indices.filter(index => {
    var _index$ilm;
    return ((_index$ilm = index.ilm) === null || _index$ilm === void 0 ? void 0 : _index$ilm.managed) && index.ilm.failed_step;
  });
  if (!indicesWithFailedStep.length) {
    return null;
  }
  const indexNames = indicesWithFailedStep.map(({
    name
  }) => name);
  return {
    requestMethod: _api.retryLifecycleForIndex,
    icon: 'play',
    indexNames: [indexNames],
    buttonLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.retryIndexLifecycleActionButtonLabel', {
      defaultMessage: 'Retry failed lifecycle step'
    }),
    successMessage: _i18n.i18n.translate('xpack.indexLifecycleMgmt.retryIndexLifecycleAction.retriedLifecycleMessage', {
      defaultMessage: 'Called retry lifecycle step for: {indexNames}',
      values: {
        indexNames: indexNames.map(indexName => `"${indexName}"`).join(', ')
      }
    })
  };
};
exports.retryLifecycleActionExtension = retryLifecycleActionExtension;
const removeLifecyclePolicyActionExtension = ({
  indices,
  reloadIndices
}) => {
  const allHaveIlm = (0, _lodash.every)(indices, index => {
    return index.ilm && index.ilm.managed;
  });
  if (!allHaveIlm) {
    return null;
  }
  const indexNames = indices.map(({
    name
  }) => name);
  return {
    renderConfirmModal: closeModal => {
      return /*#__PURE__*/_react.default.createElement(_remove_lifecycle_confirm_modal.RemoveLifecyclePolicyConfirmModal, {
        indexNames: indexNames,
        closeModal: closeModal,
        reloadIndices: reloadIndices,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 66,
          columnNumber: 9
        }
      });
    },
    icon: 'stopFilled',
    indexNames: [indexNames],
    buttonLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.removeIndexLifecycleActionButtonLabel', {
      defaultMessage: 'Remove lifecycle policy'
    })
  };
};
exports.removeLifecyclePolicyActionExtension = removeLifecyclePolicyActionExtension;
const addLifecyclePolicyActionExtension = ({
  indices,
  reloadIndices,
  getUrlForApp
}) => {
  if (indices.length !== 1) {
    return null;
  }
  const index = indices[0];
  const hasIlm = index.ilm && index.ilm.managed;
  if (hasIlm) {
    return null;
  }
  const indexName = index.name;
  return {
    renderConfirmModal: closeModal => {
      return /*#__PURE__*/_react.default.createElement(_add_lifecycle_confirm_modal.AddLifecyclePolicyConfirmModal, {
        indexName: indexName,
        closeModal: closeModal,
        index: index,
        reloadIndices: reloadIndices,
        getUrlForApp: getUrlForApp,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 9
        }
      });
    },
    icon: 'plusInCircle',
    buttonLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.addLifecyclePolicyActionButtonLabel', {
      defaultMessage: 'Add lifecycle policy'
    })
  };
};
exports.addLifecyclePolicyActionExtension = addLifecyclePolicyActionExtension;
const ilmBannerExtension = indices => {
  var _retryAction$indexNam, _retryAction$indexNam2;
  const {
    Query
  } = _eui.EuiSearchBar;
  if (!indices.length) {
    return null;
  }
  const indicesWithLifecycleErrors = indices.filter(index => {
    return (0, _lodash.get)(index, stepPath) === 'ERROR';
  });
  const numIndicesWithLifecycleErrors = indicesWithLifecycleErrors.length;
  if (!numIndicesWithLifecycleErrors) {
    return null;
  }
  const retryAction = retryLifecycleActionExtension({
    indices: indicesWithLifecycleErrors
  });
  return {
    type: 'warning',
    filter: Query.parse(`${stepPath}:ERROR`),
    filterLabel: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexMgmtBanner.filterLabel', {
      defaultMessage: 'Show errors'
    }),
    // retryAction can be set to null if the retry action is not applicable to all the indices with lifecycle errors
    ...(retryAction && {
      action: {
        buttonLabel: retryAction.buttonLabel,
        indexNames: (_retryAction$indexNam = (_retryAction$indexNam2 = retryAction.indexNames) === null || _retryAction$indexNam2 === void 0 ? void 0 : _retryAction$indexNam2[0]) !== null && _retryAction$indexNam !== void 0 ? _retryAction$indexNam : [],
        requestMethod: retryAction.requestMethod,
        successMessage: retryAction.successMessage
      }
    }),
    title: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexMgmtBanner.errorMessage', {
      defaultMessage: `{ numIndicesWithLifecycleErrors, number}
          {numIndicesWithLifecycleErrors, plural, one {index has} other {indices have} }
          lifecycle errors`,
      values: {
        numIndicesWithLifecycleErrors
      }
    })
  };
};
exports.ilmBannerExtension = ilmBannerExtension;
const ilmFilterExtension = indices => {
  const hasIlm = (0, _lodash.some)(indices, index => index.ilm && index.ilm.managed);
  if (!hasIlm) {
    return [];
  } else {
    return [{
      type: 'field_value_selection',
      name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexMgmtFilter.lifecycleStatusLabel', {
        defaultMessage: 'Lifecycle status'
      }),
      multiSelect: false,
      field: 'ilm.managed',
      options: [{
        value: true,
        view: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexMgmtFilter.managedLabel', {
          defaultMessage: 'Managed'
        })
      }, {
        value: false,
        view: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexMgmtFilter.unmanagedLabel', {
          defaultMessage: 'Unmanaged'
        })
      }]
    }, {
      type: 'field_value_selection',
      field: 'ilm.phase',
      name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexMgmtFilter.lifecyclePhaseLabel', {
        defaultMessage: 'Lifecycle phase'
      }),
      multiSelect: 'or',
      autoSortOptions: false,
      options: [{
        value: 'hot',
        view: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexMgmtFilter.hotLabel', {
          defaultMessage: 'Hot'
        })
      }, {
        value: 'warm',
        view: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexMgmtFilter.warmLabel', {
          defaultMessage: 'Warm'
        })
      }, {
        value: 'frozen',
        view: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexMgmtFilter.frozenLabel', {
          defaultMessage: 'Frozen'
        })
      }, {
        value: 'cold',
        view: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexMgmtFilter.coldLabel', {
          defaultMessage: 'Cold'
        })
      }, {
        value: 'delete',
        view: _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexMgmtFilter.deleteLabel', {
          defaultMessage: 'Delete'
        })
      }]
    }];
  }
};
exports.ilmFilterExtension = ilmFilterExtension;
const addAllExtensions = extensionsService => {
  extensionsService.addAction(retryLifecycleActionExtension);
  extensionsService.addAction(removeLifecyclePolicyActionExtension);
  extensionsService.addAction(addLifecyclePolicyActionExtension);
  extensionsService.addBanner(ilmBannerExtension);
  extensionsService.addFilter(ilmFilterExtension);
  extensionsService.addIndexDetailsTab(_index_lifecycle_summary.indexLifecycleTab);
};
exports.addAllExtensions = addAllExtensions;