"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DefaultToDataTiersNotice = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../../../../../../shared_imports");
var _no_custom_attributes_messages = require("./no_custom_attributes_messages");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/components/phases/shared_fields/data_tier_allocation_field/components/default_to_data_tiers_notice.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const DefaultToDataTiersNotice = ({
  phase
}) => {
  const {
    services: {
      docLinks
    }
  } = (0, _shared_imports.useKibana)();
  const phaseTexts = {
    warm: _i18n.i18n.translate('xpack.indexLifecycleMgmt.warmPhase.dataTier.defaultAllocationNotAvailableDescription', {
      defaultMessage: 'Data will be allocated to the warm tier.'
    }),
    cold: _i18n.i18n.translate('xpack.indexLifecycleMgmt.coldPhase.dataTier.defaultAllocationNotAvailableDescription', {
      defaultMessage: 'Data will be allocated to the cold tier.'
    })
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "defaultToDataTiersNotice",
    style: {
      maxWidth: 400
    },
    title: _no_custom_attributes_messages.noCustomAttributesTitle,
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 7
    }
  }, phaseTexts[phase]), (0, _no_custom_attributes_messages.nodeAllocationMigrationGuidance)({
    docLinks
  }));
};
exports.DefaultToDataTiersNotice = DefaultToDataTiersNotice;