"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NextSteps = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../hooks");
var _plugin = require("../../../common/constants/plugin");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/components/agentless_enrollment_flyout/next_steps.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NextSteps = ({
  packagePolicy,
  policyTemplates
}) => {
  const {
    application
  } = (0, _hooks.useStartServices)();
  const configurationLinks = (0, _react.useMemo)(() => {
    if (policyTemplates) {
      return policyTemplates === null || policyTemplates === void 0 ? void 0 : policyTemplates.filter(template => (template === null || template === void 0 ? void 0 : template.configuration_links) && template.configuration_links.length > 0).flatMap(template => template.configuration_links);
    }
    return [];
  }, [policyTemplates]);
  const parseKbnLink = url => {
    // matching strings with format kbn:/app/appId/path/optionalsubpath
    const matches = url.match(/kbn:\/app\/(\w*)\/(\w*\/*)*/);
    if (matches && matches.length > 0) {
      const appId = matches[1];
      const path = matches[2];
      return {
        appId,
        path
      };
    }
    return undefined;
  };
  const isExternal = url => url.startsWith('http') || url.startsWith('https');
  const onClickLink = (0, _react.useCallback)(url => {
    if (!url) return undefined;
    if (isExternal(url)) {
      application.navigateToUrl(`${url}`);
    } else if (url.startsWith('kbn:/')) {
      const parsedLink = parseKbnLink(url);
      if (parsedLink) {
        const {
          appId,
          path
        } = parsedLink;
        application.navigateToApp(appId, {
          path
        });
      }
    }
  }, [application]);
  const nextStepsCards = configurationLinks.filter(link => (link === null || link === void 0 ? void 0 : link.type) === 'next_step').map((link, index) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      "data-test-subj": `agentlessStepConfirmData.connectorCard.${link === null || link === void 0 ? void 0 : link.title}`,
      title: `${link === null || link === void 0 ? void 0 : link.title}`,
      description: `${link === null || link === void 0 ? void 0 : link.content}`,
      onClick: () => onClickLink(link === null || link === void 0 ? void 0 : link.url),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 11
      }
    }));
  });
  const connectorCards = packagePolicy.inputs.filter(input => {
    var _input$vars, _input$vars$connector, _input$vars2, _input$vars2$connecto;
    return !!(input !== null && input !== void 0 && (_input$vars = input.vars) !== null && _input$vars !== void 0 && (_input$vars$connector = _input$vars.connector_id) !== null && _input$vars$connector !== void 0 && _input$vars$connector.value) || !!(input !== null && input !== void 0 && (_input$vars2 = input.vars) !== null && _input$vars2 !== void 0 && (_input$vars2$connecto = _input$vars2.connector_name) !== null && _input$vars2$connecto !== void 0 && _input$vars2$connecto.value);
  }).map((input, index) => {
    var _input$vars3, _input$vars3$connecto, _input$vars4;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      "data-test-subj": `agentlessStepConfirmData.connectorCard.${input === null || input === void 0 ? void 0 : (_input$vars3 = input.vars) === null || _input$vars3 === void 0 ? void 0 : (_input$vars3$connecto = _input$vars3.connector_name) === null || _input$vars3$connecto === void 0 ? void 0 : _input$vars3$connecto.value}`,
      title: `${input === null || input === void 0 ? void 0 : (_input$vars4 = input.vars) === null || _input$vars4 === void 0 ? void 0 : _input$vars4.connector_name.value}`,
      description: _i18n.i18n.translate('xpack.fleet.agentlessStepConfirmData.connectorCard.description', {
        defaultMessage: 'Configure Connector'
      }),
      onClick: () => {
        var _input$vars5, _input$vars5$connecto, _input$vars6, _input$vars6$connecto;
        application.navigateToApp(_plugin.ELASTICSEARCH_PLUGIN_ID, {
          path: input !== null && input !== void 0 && (_input$vars5 = input.vars) !== null && _input$vars5 !== void 0 && (_input$vars5$connecto = _input$vars5.connector_id) !== null && _input$vars5$connecto !== void 0 && _input$vars5$connecto.value ? `content/connectors/${input === null || input === void 0 ? void 0 : (_input$vars6 = input.vars) === null || _input$vars6 === void 0 ? void 0 : (_input$vars6$connecto = _input$vars6.connector_id) === null || _input$vars6$connecto === void 0 ? void 0 : _input$vars6$connecto.value}` : `content/connectors`
        });
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 11
      }
    }));
  });
  const actionButtons = configurationLinks.filter(link => !!link && (link === null || link === void 0 ? void 0 : link.type) === 'action').map((link, index) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: index,
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": `agentlessStepConfirmData.connectorCard.${link === null || link === void 0 ? void 0 : link.title}`,
      iconType: "link",
      onClick: () => onClickLink(link === null || link === void 0 ? void 0 : link.url),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 121,
        columnNumber: 11
      }
    }, link === null || link === void 0 ? void 0 : link.title));
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }), (nextStepsCards.length > 0 || connectorCards.length > 0) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "row",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, nextStepsCards, connectorCards), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }), actionButtons.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "row",
    wrap: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }, actionButtons));
};
exports.NextSteps = NextSteps;