"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DisabledWrapperTooltip = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/installed_integrations/components/disabled_wrapper_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Wrapper to display a tooltip if element is disabled (i.e. due to insufficient permissions)
 */
const DisabledWrapperTooltip = ({
  children,
  disabled,
  tooltipContent
}) => {
  if (disabled) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: tooltipContent,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 20,
        columnNumber: 12
      }
    }, children);
  } else {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
  }
};
exports.DisabledWrapperTooltip = DisabledWrapperTooltip;