"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Details = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/custom-integrations-plugin/public");
var _lodash = require("lodash");
var _types = require("../../../../../types");
var _hooks = require("../../../../../hooks");
var _constants = require("../../../constants");
var _changelog_modal = require("../settings/changelog_modal");
var _hooks2 = require("../hooks");
var _notice_modal = require("./notice_modal");
var _license_modal = require("./license_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/integrations/sections/epm/screens/detail/overview/details.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ReplacementCard = (0, _public.withSuspense)(_public.LazyReplacementCard);
const Replacements = (0, _common.euiStyled)(_eui.EuiFlexItem)`
  margin: 0;

  & .euiAccordion {
    padding-top: ${({
  theme
}) => parseInt(theme.eui.euiSizeL, 10) * 2}px;

    &::before {
      content: '';
      display: block;
      border-top: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
      position: relative;
      top: -${({
  theme
}) => theme.eui.euiSizeL};
      margin: 0 ${({
  theme
}) => theme.eui.euiSizeXS};
    }
  }
`;
const Details = exports.Details = /*#__PURE__*/(0, _react.memo)(({
  packageInfo,
  integrationInfo
}) => {
  var _packageInfo$conditio3, _packageInfo$conditio4, _packageInfo$source4, _packageInfo$source5;
  const {
    notifications
  } = (0, _hooks.useStartServices)();
  const config = (0, _hooks.useConfig)();
  const {
    data: categoriesData,
    isLoading: isLoadingCategories
  } = (0, _hooks.useGetCategoriesQuery)();
  const {
    changelog,
    isLoading: isChangelogLoading,
    error: changelogError
  } = (0, _hooks2.useChangelog)(packageInfo.name, packageInfo.version);
  const mergedCategories = (0, _react.useMemo)(() => {
    let allCategories = [];
    if (packageInfo !== null && packageInfo !== void 0 && packageInfo.categories) {
      allCategories = packageInfo.categories;
    }
    if (integrationInfo !== null && integrationInfo !== void 0 && integrationInfo.categories) {
      allCategories = (0, _lodash.uniq)([...allCategories, ...((integrationInfo === null || integrationInfo === void 0 ? void 0 : integrationInfo.categories) || [])]);
    }
    return allCategories;
  }, [integrationInfo, packageInfo === null || packageInfo === void 0 ? void 0 : packageInfo.categories]);
  const packageCategories = (0, _react.useMemo)(() => {
    if (!isLoadingCategories && categoriesData !== null && categoriesData !== void 0 && categoriesData.items) {
      return categoriesData.items.filter(category => mergedCategories === null || mergedCategories === void 0 ? void 0 : mergedCategories.includes(category.id)).map(category => category.title);
    }
    return [];
  }, [categoriesData, isLoadingCategories, mergedCategories]);
  const [isNoticeModalOpen, setIsNoticeModalOpen] = (0, _react.useState)(false);
  const toggleNoticeModal = (0, _react.useCallback)(() => {
    setIsNoticeModalOpen(currentState => !currentState);
  }, []);
  const [isLicenseModalOpen, setIsLicenseModalOpen] = (0, _react.useState)(false);
  const toggleLicenseModal = (0, _react.useCallback)(() => {
    setIsLicenseModalOpen(currentState => !currentState);
  }, []);
  const [isChangelogModalOpen, setIsChangelogModalOpen] = (0, _react.useState)(false);
  const toggleChangelogModal = (0, _react.useCallback)(() => {
    setIsChangelogModalOpen(currentState => !currentState);
  }, []);
  const listItems = (0, _react.useMemo)(() => {
    var _packageInfo$data_str, _packageInfo$data_str2, _packageInfo$conditio, _packageInfo$conditio2, _packageInfo$source;
    // Base details: version and categories
    const items = [{
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 123,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.versionLabel",
        defaultMessage: "Version",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 124,
          columnNumber: 13
        }
      })),
      description: packageInfo.version
    }, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 131,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.categoryLabel",
        defaultMessage: "Category",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 132,
          columnNumber: 13
        }
      })),
      description: packageCategories.join(', ')
    }];

    // Asset details and counts
    (0, _types.entries)(packageInfo.assets).forEach(([service, typeToParts]) => {
      // Filter out assets we are not going to display
      // (currently we only display Kibana and Elasticsearch assets)
      // and filter out dashboard references if configured
      const filteredTypes = (0, _types.entries)(typeToParts).reduce((acc, [asset, value]) => {
        if (_constants.DisplayedAssetsFromPackageInfo[service].includes(asset) && (!(config !== null && config !== void 0 && config.hideDashboards) || asset !== 'dashboard')) {
          acc[asset] = value;
        }
        return acc;
      }, {});
      if (Object.entries(filteredTypes).length) {
        items.push({
          title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
            color: "subdued",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 159,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.fleet.epm.assetGroupTitle",
            defaultMessage: "{assetType} assets",
            values: {
              assetType: _constants.ServiceTitleMap[service]
            },
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 160,
              columnNumber: 15
            }
          })),
          description: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            direction: "column",
            gutterSize: "xs",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 170,
              columnNumber: 13
            }
          }, (0, _types.entries)(filteredTypes).map(([_type, parts], index) => {
            const type = _type;
            // For transforms, count unique transform modules since multiple files can belong to the same transform
            // For all other asset types, count all parts
            const assetCount = _type === 'transform' ? new Set(parts.map(part => part.file)).size : parts.length;
            return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
              key: `item-${index}`,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 181,
                columnNumber: 19
              }
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
              gutterSize: "xs",
              alignItems: "center",
              justifyContent: "spaceBetween",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 182,
                columnNumber: 21
              }
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
              grow: false,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 183,
                columnNumber: 23
              }
            }, _constants.AssetTitleMap[type]), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
              grow: false,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 184,
                columnNumber: 23
              }
            }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
              color: "subdued",
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 185,
                columnNumber: 25
              }
            }, assetCount))));
          }))
        });
      }
    });

    // Feature (data stream type) details
    const dataStreamTypes = [...new Set(((_packageInfo$data_str = packageInfo.data_streams) === null || _packageInfo$data_str === void 0 ? void 0 : _packageInfo$data_str.map(dataStream => dataStream.type)) || [])];
    if (dataStreamTypes.length) {
      items.push({
        title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "subdued",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 204,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.featuresLabel",
          defaultMessage: "Features",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 205,
            columnNumber: 13
          }
        })),
        description: dataStreamTypes.join(', ')
      });
    }

    // Ingestion method details
    const ingestionMethods = new Set();
    (_packageInfo$data_str2 = packageInfo.data_streams) === null || _packageInfo$data_str2 === void 0 ? void 0 : _packageInfo$data_str2.forEach(dataStream => {
      var _dataStream$streams;
      (_dataStream$streams = dataStream.streams) === null || _dataStream$streams === void 0 ? void 0 : _dataStream$streams.forEach(stream => {
        if (stream.ingestion_method) {
          ingestionMethods.add(stream.ingestion_method);
        }
      });
    });
    if (ingestionMethods.size > 0) {
      items.push({
        title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "subdued",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 224,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.ingestionMethodsLabel",
          defaultMessage: "Ingestion methods",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 225,
            columnNumber: 13
          }
        })),
        description: Array.from(ingestionMethods).join(', ')
      });
    }

    // Subscription details
    items.push({
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 238,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.subscriptionLabel",
        defaultMessage: "Subscription",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 239,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 243,
          columnNumber: 9
        }
      }, ((_packageInfo$conditio = packageInfo.conditions) === null || _packageInfo$conditio === void 0 ? void 0 : (_packageInfo$conditio2 = _packageInfo$conditio.elastic) === null || _packageInfo$conditio2 === void 0 ? void 0 : _packageInfo$conditio2.subscription) || packageInfo.license || '-')
    });
    let ownerTypeDescription;
    switch (packageInfo.owner.type) {
      case 'community':
        ownerTypeDescription = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.ownerTypeCommunityDescription",
          defaultMessage: "Community",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 251,
            columnNumber: 11
          }
        });
        break;
      case 'partner':
        ownerTypeDescription = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.ownerTypePartnerDescription",
          defaultMessage: "Partner",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 259,
            columnNumber: 11
          }
        });
        break;
      case 'elastic':
        ownerTypeDescription = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.ownerTypeElasticDescription",
          defaultMessage: "Elastic",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 267,
            columnNumber: 11
          }
        });
        break;
    }
    if (ownerTypeDescription) {
      items.push({
        title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "subdued",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 278,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.ownerTypeLabel",
          defaultMessage: "Developed by",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 279,
            columnNumber: 13
          }
        })),
        description: ownerTypeDescription
      });
    }

    // License details
    if (packageInfo.licensePath || (_packageInfo$source = packageInfo.source) !== null && _packageInfo$source !== void 0 && _packageInfo$source.license || packageInfo.notice) {
      var _packageInfo$source2, _packageInfo$source3;
      items.push({
        title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "subdued",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 290,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.fleet.epm.licenseLabel",
          defaultMessage: "License",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 291,
            columnNumber: 13
          }
        })),
        description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, packageInfo.licensePath ? /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 297,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: toggleLicenseModal,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 298,
            columnNumber: 17
          }
        }, ((_packageInfo$source2 = packageInfo.source) === null || _packageInfo$source2 === void 0 ? void 0 : _packageInfo$source2.license) || 'LICENSE.txt')) : /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 303,
            columnNumber: 15
          }
        }, ((_packageInfo$source3 = packageInfo.source) === null || _packageInfo$source3 === void 0 ? void 0 : _packageInfo$source3.license) || '-'), packageInfo.notice && /*#__PURE__*/_react.default.createElement("p", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 306,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          onClick: toggleNoticeModal,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 307,
            columnNumber: 17
          }
        }, "NOTICE.txt")))
      });
    }
    items.push({
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 317,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.epm.changelogLabel",
        defaultMessage: "Changelog",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 318,
          columnNumber: 11
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 323,
          columnNumber: 11
        }
      }, changelog.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        onClick: toggleChangelogModal,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 325,
          columnNumber: 15
        }
      }, "View Changelog") : '-'))
    });
    return items;
  }, [changelog, packageCategories, packageInfo.assets, (_packageInfo$conditio3 = packageInfo.conditions) === null || _packageInfo$conditio3 === void 0 ? void 0 : (_packageInfo$conditio4 = _packageInfo$conditio3.elastic) === null || _packageInfo$conditio4 === void 0 ? void 0 : _packageInfo$conditio4.subscription, packageInfo.data_streams, packageInfo.license, packageInfo.licensePath, packageInfo.notice, (_packageInfo$source4 = packageInfo.source) === null || _packageInfo$source4 === void 0 ? void 0 : _packageInfo$source4.license, packageInfo.owner.type, packageInfo.version, config === null || config === void 0 ? void 0 : config.hideDashboards, toggleLicenseModal, toggleNoticeModal, toggleChangelogModal]);
  (0, _react.useEffect)(() => {
    if (changelogError) {
      notifications.toasts.addError(changelogError, {
        title: _i18n.i18n.translate('xpack.fleet.epm.errorLoadingChangelog', {
          defaultMessage: 'Error loading changelog information'
        })
      });
    }
  }, [changelogError, notifications.toasts]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 365,
      columnNumber: 7
    }
  }, isNoticeModalOpen && packageInfo.notice && /*#__PURE__*/_react.default.createElement(_notice_modal.NoticeModal, {
    noticePath: packageInfo.notice,
    onClose: toggleNoticeModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 367,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 370,
      columnNumber: 7
    }
  }, isLicenseModalOpen && packageInfo.licensePath && /*#__PURE__*/_react.default.createElement(_license_modal.LicenseModal, {
    licenseName: (_packageInfo$source5 = packageInfo.source) === null || _packageInfo$source5 === void 0 ? void 0 : _packageInfo$source5.license,
    licensePath: packageInfo.licensePath,
    onClose: toggleLicenseModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 372,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 379,
      columnNumber: 7
    }
  }, isChangelogModalOpen && /*#__PURE__*/_react.default.createElement(_changelog_modal.ChangelogModal, {
    changelog: changelog,
    isLoading: isChangelogLoading,
    onClose: toggleChangelogModal,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 381,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 388,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 389,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 390,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h4", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 391,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.epm.detailsTitle",
    defaultMessage: "Details",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 392,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 396,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    compressed: true,
    listItems: listItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 397,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(Replacements, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 399,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(ReplacementCard, {
    eprPackageName: packageInfo.name,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 400,
      columnNumber: 11
    }
  }))));
});