"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetServerHostsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../hooks");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/fleet_server_hosts_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NameFlexItemWithMaxWidth = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  max-width: 250px;
`;

// Allow child to be truncated
const FlexGroupWithMinWidth = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  min-width: 0px;
`;
const FleetServerHostsTable = ({
  fleetServerHosts,
  deleteFleetServerHost
}) => {
  const authz = (0, _hooks.useAuthz)();
  const {
    getHref
  } = (0, _hooks.useLink)();
  const columns = (0, _react.useMemo)(() => {
    return [{
      render: fleetServerHost => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(NameFlexItemWithMaxWidth, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 51,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        title: fleetServerHost.name,
        className: `eui-textTruncate`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 52,
          columnNumber: 15
        }
      }, fleetServerHost.name)), fleetServerHost.is_preconfigured && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsTable.managedTooltip', {
          defaultMessage: 'This Fleet server host is managed outside of Fleet. Please refer to your kibana config file for more info.'
        }),
        type: "lock",
        size: "m",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 58,
          columnNumber: 17
        }
      }))),
      width: '288px',
      name: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsTable.nameColumnTitle', {
        defaultMessage: 'Name'
      })
    }, {
      truncateText: true,
      field: 'host_urls',
      render: urls => /*#__PURE__*/_react.default.createElement(FlexGroupWithMinWidth, {
        direction: "column",
        gutterSize: "xs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 11
        }
      }, urls.map(url => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: url,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 85,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        title: url,
        className: `eui-textTruncate`,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 17
        }
      }, url)))),
      name: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsTable.hostUrlsColumnTitle', {
        defaultMessage: 'Host URLs'
      })
    }, {
      render: fleetServerHost => fleetServerHost.is_default ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "check",
        "data-test-subj": "fleetServerHostTable.defaultIcon",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 100,
          columnNumber: 13
        }
      }) : null,
      width: '200px',
      name: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsTable.defaultColumnTitle', {
        defaultMessage: 'Default'
      })
    }, {
      width: '68px',
      render: fleetServerHost => {
        const isDeleteVisible = !fleetServerHost.is_default && !fleetServerHost.is_preconfigured && authz.fleet.allSettings;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "s",
          justifyContent: "flexEnd",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 116,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 117,
            columnNumber: 15
          }
        }, isDeleteVisible && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          color: "text",
          iconType: "trash",
          onClick: () => deleteFleetServerHost(fleetServerHost),
          title: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsTable.deleteButtonTitle', {
            defaultMessage: 'Delete'
          }),
          "aria-label": _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsTable.deleteButtonAriaLabel', {
            defaultMessage: 'Delete host'
          }),
          "data-test-subj": "fleetServerHostsTable.delete.btn",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 119,
            columnNumber: 19
          }
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
          grow: false,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 139,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
          color: "text",
          iconType: "pencil",
          href: getHref('settings_edit_fleet_server_hosts', {
            itemId: fleetServerHost.id
          }),
          title: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsTable.editButtonTitle', {
            defaultMessage: 'Edit'
          }),
          "aria-label": _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsTable.editButtonAriaLabel', {
            defaultMessage: 'Edit host'
          }),
          "data-test-subj": "fleetServerHostsTable.edit.btn",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 140,
            columnNumber: 17
          }
        })));
      },
      name: _i18n.i18n.translate('xpack.fleet.settings.fleetServerHostsTable.actionsColumnTitle', {
        defaultMessage: 'Actions'
      })
    }];
  }, [getHref, deleteFleetServerHost, authz.fleet.allSettings]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    columns: columns,
    items: fleetServerHosts,
    "data-test-subj": "settingsFleetServerHostsTable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 5
    }
  });
};
exports.FleetServerHostsTable = FleetServerHostsTable;