"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableRowActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../../common/constants");
var _hooks = require("../../../../hooks");
var _services = require("../../../../services");
var _services2 = require("../../../../../../../common/services");
var _agent_status = require("../../../../../../../common/services/agent_status");
var _use_authz = require("../../../../../../hooks/use_authz");
var _components = require("../../../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/table_row_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TableRowActions = ({
  agent,
  agentPolicy,
  onReassignClick,
  onUnenrollClick,
  onGetUninstallCommandClick,
  onUpgradeClick,
  onAddRemoveTagsClick,
  onRequestDiagnosticsClick,
  onMigrateAgentClick,
  onChangeAgentPrivilegeLevelClick
}) => {
  const {
    getHref
  } = (0, _hooks.useLink)();
  const authz = (0, _use_authz.useAuthz)();
  const licenseService = (0, _hooks.useLicense)();
  const isUnenrolling = agent.status === 'unenrolling';
  const agentPrivilegeLevelChangeEnabled = _services.ExperimentalFeaturesService.get().enableAgentPrivilegeLevelChange;
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const menuItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    icon: "inspect",
    href: getHref('agent_details', {
      agentId: agent.id
    }),
    key: "viewAgent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.viewActionText",
    defaultMessage: "View agent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }))];
  if (authz.fleet.allAgents && (0, _services2.isAgentEligibleForMigration)(agent, agentPolicy)) {
    menuItems.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "cluster",
      onClick: () => {
        onMigrateAgentClick();
        setIsMenuOpen(false);
      },
      disabled: !agent.active || !licenseService.hasAtLeast(_constants.LICENSE_FOR_AGENT_MIGRATION),
      key: "migrateAgent",
      "data-test-subj": "migrateAgentMenuItem",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.migrateAgentActionText",
      defaultMessage: "Migrate agent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 9
      }
    })));
  }
  if (authz.fleet.allAgents && (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.is_managed) === false) {
    menuItems.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "tag",
      onClick: event => {
        onAddRemoveTagsClick(event.target.closest('button'));
      },
      disabled: !agent.active,
      key: "addRemoveTags",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.addRemoveTagsActionText",
      defaultMessage: "Add / remove tags",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 9
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "pencil",
      onClick: () => {
        onReassignClick();
      },
      disabled: !agent.active || (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.supports_agentless) === true,
      key: "reassignPolicy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.reassignActionText",
      defaultMessage: "Assign to new policy",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 9
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "agentUnenrollBtn",
      disabled: !agent.active || (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.supports_agentless) === true,
      icon: "trash",
      onClick: () => {
        onUnenrollClick();
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 7
      }
    }, isUnenrolling ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.forceUnenrollOneButton",
      defaultMessage: "Force unenroll",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.unenrollOneButton",
      defaultMessage: "Unenroll agent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "agentUpgradeBtn",
      icon: "refresh",
      disabled: !(0, _services.isAgentUpgradeable)(agent) || (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.supports_agentless) === true,
      onClick: () => {
        onUpgradeClick();
      },
      "data-test-subj": "upgradeBtn",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.upgradeOneButton",
      defaultMessage: "Upgrade agent",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 9
      }
    })));
    if (authz.fleet.allAgents && (0, _agent_status.isStuckInUpdating)(agent)) {
      menuItems.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "agentRestartUpgradeBtn",
        icon: "refresh",
        onClick: () => {
          onUpgradeClick();
        },
        "data-test-subj": "restartUpgradeBtn",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 154,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentList.restartUpgradeOneButton",
        defaultMessage: "Restart upgrade",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 11
        }
      })));
    }
    if (authz.fleet.allAgents && agent.policy_id && !(agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.supports_agentless)) {
      menuItems.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        icon: "minusInCircle",
        onClick: () => {
          onGetUninstallCommandClick();
          setIsMenuOpen(false);
        },
        disabled: !agent.active,
        key: "getUninstallCommand",
        "data-test-subj": "uninstallAgentMenuItem",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 172,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentList.getUninstallCommand",
        defaultMessage: "Uninstall agent",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 182,
          columnNumber: 11
        }
      })));
    }
  }
  if (authz.fleet.allAgents && (0, _services2.isAgentEligibleForPrivilegeLevelChange)(agent, agentPolicy) && agentPrivilegeLevelChangeEnabled) {
    menuItems.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      icon: "lock",
      onClick: () => {
        onChangeAgentPrivilegeLevelClick();
        setIsMenuOpen(false);
      },
      disabled: !agent.active,
      key: "changeAgentPrivilegeLevel",
      "data-test-subj": "changeAgentPrivilegeLevelMenuItem",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.changeAgentPrivilegeLevelActionText",
      defaultMessage: "Remove root privilege",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 9
      }
    })));
  }
  if (authz.fleet.readAgents) {
    menuItems.push(/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      key: "requestAgentDiagnosticsBtn",
      icon: "download",
      "data-test-subj": "requestAgentDiagnosticsBtn",
      disabled: !(0, _services2.isAgentRequestDiagnosticsSupported)(agent),
      onClick: () => {
        onRequestDiagnosticsClick();
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.diagnosticsOneButton",
      defaultMessage: "Request diagnostics .zip",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 9
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_components.ContextMenuActions, {
    isOpen: isMenuOpen,
    onChange: isOpen => setIsMenuOpen(isOpen),
    items: menuItems,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 235,
      columnNumber: 5
    }
  });
};
exports.TableRowActions = TableRowActions;