"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchAndFilterBar = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _hooks = require("../../../../../integrations/sections/epm/screens/detail/hooks");
var _components = require("../../../../components");
var _constants = require("../../../../constants");
var _hooks2 = require("../../../../hooks");
var _bulk_actions = require("./bulk_actions");
var _agent_activity_button = require("./agent_activity_button");
var _agent_status_filter = require("./agent_status_filter");
var _dashboards_buttons = require("./dashboards_buttons");
var _agent_policy_filter = require("./filter_bar/agent_policy_filter");
var _tags_filter = require("./filter_bar/tags_filter");
var _agent_activity_badge = require("./agent_activity_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/search_and_filter_bar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SearchAndFilterBar = ({
  agentPolicies,
  draftKuery,
  onDraftKueryChange,
  onSubmitSearch,
  selectedAgentPolicies,
  onSelectedAgentPoliciesChange,
  selectedStatus,
  onSelectedStatusChange,
  showUpgradeable,
  onShowUpgradeableChange,
  tags,
  selectedTags,
  onSelectedTagsChange,
  nAgentsInTable,
  totalInactiveAgents,
  totalManagedAgentIds,
  selectionMode,
  currentQuery,
  selectedAgents,
  refreshAgents,
  onClickAddAgent,
  onClickAddFleetServer,
  agentsOnCurrentPage,
  onClickAgentActivity,
  shouldShowAgentActivityTour,
  latestAgentActionErrors,
  sortField,
  sortOrder,
  unsupportedMigrateAgents,
  unsupportedPrivilegeLevelChangeAgents
}) => {
  const authz = (0, _hooks2.useAuthz)();
  const {
    isFirstTimeAgentUser,
    isLoading: isFirstTimeAgentUserLoading
  } = (0, _hooks.useIsFirstTimeAgentUserQuery)();
  const {
    cloud
  } = (0, _hooks2.useStartServices)();
  const NO_TAGS_VALUE = _i18n.i18n.translate('xpack.fleet.agentList.noTagsValue', {
    defaultMessage: 'No Tags'
  });
  const tagsWithNoTagsIncluded = [...tags, NO_TAGS_VALUE];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, !isFirstTimeAgentUserLoading && !isFirstTimeAgentUser && /*#__PURE__*/_react.default.createElement(_dashboards_buttons.DashboardsButtons, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 71
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    justifyContent: "flexEnd",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_activity_badge.AgentActivityBadge, {
    recentErrors: latestAgentActionErrors,
    onClick: onClickAgentActivity,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_activity_button.AgentActivityButton, {
    onClickAgentActivity: onClickAgentActivity,
    shouldShowTour: shouldShowAgentActivityTour,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 15
    }
  })), authz.fleet.addFleetServers && !(cloud !== null && cloud !== void 0 && cloud.isServerlessEnabled) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.addFleetServerButton.tooltip",
      defaultMessage: "Fleet Server is a component of the Elastic Stack used to centrally manage Elastic Agents",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onClickAddFleetServer,
    "data-test-subj": "addFleetServerButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.addFleetServerButton",
    defaultMessage: "Add Fleet Server",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 21
    }
  })))) : null, authz.fleet.addAgents ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentList.addAgentButton.tooltip",
      defaultMessage: "Add Elastic Agents to your hosts to collect data and send it to the Elastic Stack",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: onClickAddAgent,
    "data-test-subj": "addAgentButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.addButton",
    defaultMessage: "Add agent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 21
    }
  })))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 6,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_components.SearchBar, {
    value: draftKuery,
    fieldPrefix: _constants.AGENTS_PREFIX,
    indexPattern: _constants.AGENTS_INDEX,
    onChange: (newSearch, submit) => {
      onDraftKueryChange(newSearch);
      if (submit) {
        onSubmitSearch(newSearch);
      }
    },
    dataTestSubj: "agentList.queryInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_agent_status_filter.AgentStatusFilter, {
    selectedStatus: selectedStatus,
    onSelectedStatusChange: onSelectedStatusChange,
    totalInactiveAgents: totalInactiveAgents,
    disabled: agentPolicies.length === 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_tags_filter.TagsFilter, {
    tags: tagsWithNoTagsIncluded,
    selectedTags: selectedTags,
    onSelectedTagsChange: onSelectedTagsChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_agent_policy_filter.AgentPolicyFilter, {
    selectedAgentPolicies: selectedAgentPolicies,
    onSelectedAgentPoliciesChange: onSelectedAgentPoliciesChange,
    agentPolicies: agentPolicies,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    isToggle: true,
    isSelected: showUpgradeable,
    hasActiveFilters: showUpgradeable,
    onClick: () => {
      onShowUpgradeableChange(!showUpgradeable);
    },
    "data-test-subj": "agentList.showUpgradeable",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentList.showUpgradeableFilterLabel",
    defaultMessage: "Upgrade available",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 19
    }
  })))), selectionMode === 'manual' && selectedAgents.length || selectionMode === 'query' && nAgentsInTable > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_bulk_actions.AgentBulkActions, {
    nAgentsInTable: nAgentsInTable,
    totalManagedAgentIds: totalManagedAgentIds,
    selectionMode: selectionMode,
    currentQuery: currentQuery,
    selectedAgents: selectedAgents,
    agentsOnCurrentPage: agentsOnCurrentPage,
    refreshAgents: refreshAgents,
    allTags: tags,
    agentPolicies: agentPolicies,
    sortField: sortField,
    sortOrder: sortOrder,
    unsupportedMigrateAgents: unsupportedMigrateAgents,
    unsupportedPrivilegeLevelChangeAgents: unsupportedPrivilegeLevelChangeAgents,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 17
    }
  })) : null))));
};
exports.SearchAndFilterBar = SearchAndFilterBar;