"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentsSelectionStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../constants");
var _agent_export_csv_tour = require("./agent_export_csv_tour");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/agents/agent_list_page/components/agents_selection_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Divider = _styledComponents.default.div`
  width: 0;
  height: ${props => props.theme.eui.euiSizeL};
  border-left: ${props => props.theme.eui.euiBorderThin};
`;
const FlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  height: ${props => props.theme.eui.euiSizeL};
`;
const Button = (0, _styledComponents.default)(_eui.EuiButtonEmpty)`
  .euiButtonEmpty__text {
    font-size: ${props => props.theme.eui.euiFontSizeXS};
  }
`;
const AgentsSelectionStatus = ({
  totalAgents,
  totalManagedAgents,
  selectableAgents,
  managedAgentsOnCurrentPage,
  selectionMode,
  setSelectionMode,
  selectedAgents,
  setSelectedAgents
}) => {
  const showSelectionInfoAndOptions = selectionMode === 'manual' && selectedAgents.length > 0 || selectionMode === 'query' && totalAgents > 0;
  const showSelectEverything = selectionMode === 'manual' && selectedAgents.length === selectableAgents && selectableAgents < totalAgents - managedAgentsOnCurrentPage;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    id: "agentListSelectionText",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, totalAgents > _constants.SO_SEARCH_LIMIT ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentBulkActions.totalAgentsWithLimit",
    defaultMessage: "Showing {count} of {total} agents",
    values: {
      count: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: _constants.SO_SEARCH_LIMIT,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 72,
          columnNumber: 26
        }
      }),
      total: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: totalAgents,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 73,
          columnNumber: 26
        }
      })
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 15
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentBulkActions.totalAgents",
    defaultMessage: "Showing {count, plural, one {# agent} other {# agents}}",
    values: {
      count: totalAgents
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 17
    }
  }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "info",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      "data-test-subj": "selectedAgentCountTooltip",
      id: "xpack.fleet.agentBulkActions.agentsBreakDownTooltip",
      defaultMessage: " {totalAgents} total agents: {totalSelected} user-managed agents, {totalManagedAgents} on hosted policies",
      values: {
        totalAgents,
        totalManagedAgents,
        totalSelected: totalAgents - totalManagedAgents
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 21
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 17
    }
  }))), /*#__PURE__*/_react.default.createElement(_agent_export_csv_tour.AgentExportCSVTour, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  })), showSelectionInfoAndOptions ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(Divider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued",
    "data-test-subj": "selectedAgentCountLabel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentBulkActions.agentsSelected",
    defaultMessage: "{selectionMode, select, manual { {count, plural, one {# agent} other {# agents}} } other {All agents} } selected",
    values: {
      selectionMode,
      count: selectedAgents.length
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 17
    }
  }), ' ', selectionMode === 'query' && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    type: "info",
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      "data-test-subj": "selectedAgentCountTooltip",
      id: "xpack.fleet.agentBulkActions.agentsSelectedTooltip",
      defaultMessage: "{totalSelected} user-managed agents selected: {totalAgents} total agents, {totalManagedAgents} on hosted policies. Most actions are only available to user-managed agents.",
      values: {
        totalAgents,
        totalManagedAgents,
        totalSelected: totalAgents - totalManagedAgents
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 23
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 19
    }
  }))), showSelectEverything ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(Divider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 19
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(Button, {
    size: "xs",
    flush: "left",
    "data-test-subj": "selectedEverythingOnAllPagesButton",
    onClick: () => setSelectionMode('query'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentBulkActions.selectAll",
    defaultMessage: "Select everything on all pages",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 21
    }
  })))) : null, /*#__PURE__*/_react.default.createElement(FlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(Divider, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(Button, {
    size: "xs",
    flush: "left",
    "data-test-subj": "clearAgentSelectionButton",
    onClick: () => {
      setSelectionMode('manual');
      setSelectedAgents([]);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentBulkActions.clearSelection",
    defaultMessage: "Clear selection",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 17
    }
  })))) : /*#__PURE__*/_react.default.createElement(FlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 11
    }
  })));
};
exports.AgentsSelectionStatus = AgentsSelectionStatus;