"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EcsFieldsRepository = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _PathReporter = require("io-ts/PathReporter");
var _lodash = require("lodash");
var _Either = require("fp-ts/Either");
var _field_metadata = require("../../../../common/fields_metadata/models/field_metadata");
var _fields_metadata = require("../../../../common/fields_metadata");
var _fields_metadata_dictionary = require("../../../../common/fields_metadata/models/fields_metadata_dictionary");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class EcsFieldsRepository {
  constructor(ecsFields) {
    (0, _defineProperty2.default)(this, "fieldsDictionary", void 0);
    const fields = (0, _lodash.mapValues)(ecsFields, field => _field_metadata.FieldMetadata.create({
      ...field,
      source: 'ecs'
    }));
    // Create dictionary once - it contains proxied fields for prefix support
    this.fieldsDictionary = _fields_metadata_dictionary.FieldsMetadataDictionary.create(fields);
  }
  getByName(fieldName) {
    // Access from the dictionary's proxied fields - handles both direct and prefixed lookups
    return this.fieldsDictionary.getFields()[fieldName];
  }
  find({
    fieldNames
  } = {}) {
    if (!fieldNames) {
      // Return the entire dictionary
      return this.fieldsDictionary;
    }
    const fields = fieldNames.reduce((fieldsMetadata, fieldName) => {
      const field = this.getByName(fieldName);
      if (field) {
        fieldsMetadata[fieldName] = field;
      }
      return fieldsMetadata;
    }, {});

    // Create a new dictionary with the filtered fields (also gets proxy)
    return _fields_metadata_dictionary.FieldsMetadataDictionary.create(fields);
  }
  static create({
    ecsFields
  }) {
    const decodedFields = _fields_metadata.fieldsMetadataDictionaryRT.decode(ecsFields);
    if ((0, _Either.isLeft)(decodedFields)) {
      throw Error(`EcsFieldsRepositoryDeps.create: could not validate data: ${_PathReporter.PathReporter.report(decodedFields).join('\n')}`);
    }
    return new EcsFieldsRepository(decodedFields.right);
  }
}
exports.EcsFieldsRepository = EcsFieldsRepository;