"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldsMetadataClient = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _hashed_cache = require("../../../common/hashed_cache");
var _latest = require("../../../common/latest");
var _fields_metadata = require("../../../common/fields_metadata");
var _runtime_types = require("../../../common/runtime_types");
var _create_proxied_fields_map = require("../../../common/fields_metadata/utils/create_proxied_fields_map");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class FieldsMetadataClient {
  constructor(http) {
    (0, _defineProperty2.default)(this, "cache", void 0);
    this.http = http;
    this.cache = new _hashed_cache.HashedCache();
  }
  async find(params) {
    var _params$fieldNames;
    // Initially lookup for existing results given request parameters
    if (this.cache.has(params)) {
      return this.cache.get(params);
    }

    // Convert FieldName[] to string[] for the encoder
    // - TypeScript interface allows FieldName[] (which can include numbers)
    // - Runtime encoder expects string[] only
    const encodableParams = {
      ...params,
      fieldNames: (_params$fieldNames = params.fieldNames) === null || _params$fieldNames === void 0 ? void 0 : _params$fieldNames.map(name => String(name))
    };
    const query = _latest.findFieldsMetadataRequestQueryRT.encode(encodableParams);
    const response = await this.http.get(_fields_metadata.FIND_FIELDS_METADATA_URL, {
      query,
      version: '1'
    }).catch(error => {
      throw new _fields_metadata.FetchFieldsMetadataError(`Failed to fetch fields ${truncateFieldNamesList(params.fieldNames)}: ${error.message}`);
    });
    const data = (0, _runtime_types.decodeOrThrow)(_latest.findFieldsMetadataResponsePayloadRT, message => new _fields_metadata.DecodeFieldsMetadataError(`Failed decoding fields ${truncateFieldNamesList(params.fieldNames)}: ${message}`))(response);

    // Apply proxy to support prefixed field access on the client side (reuses shared utility)
    const proxiedData = {
      fields: (0, _create_proxied_fields_map.createProxiedPlainFields)(data.fields)
    };

    // Store cached results for given request parameters
    this.cache.set(params, proxiedData);
    return proxiedData;
  }
}
exports.FieldsMetadataClient = FieldsMetadataClient;
const truncateFieldNamesList = fieldNames => {
  if (!fieldNames || fieldNames.length === 0) return '';
  const visibleFields = fieldNames.slice(0, 3);
  const additionalFieldsCount = fieldNames.length - visibleFields.length;
  return visibleFields.join().concat(additionalFieldsCount > 0 ? `+${additionalFieldsCount} fields` : '');
};