"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.query = exports.qry = void 0;
var _parser = require("../parser");
var _tag = require("./tag");
var _synth_node = require("./synth_node");
var _constants = require("../parser/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const doesNotStartWithProcessingCommand = src => {
  const tokens = _parser.Parser.tokens(src, 1);
  if (tokens.length === 0) {
    return false;
  }
  const token = tokens[0].text.toUpperCase();
  if (_constants.HEADER_COMMANDS.has(token)) {
    return true;
  }
  return _constants.SOURCE_COMMANDS.has(token);
};
const generator = (src, {
  withFormatting = true,
  ...rest
} = {}) => {
  src = src.trimStart();
  const options = {
    withFormatting,
    ...rest
  };
  const isSourceQuery = doesNotStartWithProcessingCommand(src);
  if (!isSourceQuery) {
    src = `FROM a | ${src}`;
  }
  const {
    root
  } = _parser.Parser.parseQuery(src, options);
  if (!isSourceQuery) {
    root.commands.shift();
  }
  const node = _synth_node.SynthNode.from(root);
  return node;
};
const query = exports.query = (0, _tag.createTag)(generator);

/**
 * Short 3-letter alias for DX convenience.
 */
const qry = exports.qry = query;