"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAuthorizationContext = exports.AuthorizationProvider = exports.AuthorizationContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _request = require("../../../public/request");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/es_ui_shared/__packages_do_not_import__/authorization/components/authorization_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
// eslint-disable-next-line @kbn/imports/no_boundary_crossing
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const initialValue = {
  isLoading: true,
  apiError: null,
  privileges: {
    hasAllPrivileges: true,
    missingPrivileges: {}
  }
};
const AuthorizationContext = exports.AuthorizationContext = /*#__PURE__*/(0, _react.createContext)(initialValue);
const useAuthorizationContext = () => {
  const ctx = (0, _react.useContext)(AuthorizationContext);
  if (!ctx) {
    throw new Error('AuthorizationContext can only be used inside of AuthorizationProvider!');
  }
  return ctx;
};
exports.useAuthorizationContext = useAuthorizationContext;
const AuthorizationProvider = ({
  privilegesEndpoint,
  httpClient,
  children
}) => {
  const {
    isLoading,
    error,
    data: privilegesData
  } = (0, _request.useRequest)(httpClient, {
    path: privilegesEndpoint,
    method: 'get'
  });
  const value = {
    isLoading,
    privileges: isLoading ? {
      hasAllPrivileges: true,
      missingPrivileges: {}
    } : privilegesData,
    apiError: error ? error : null
  };
  return /*#__PURE__*/_react.default.createElement(AuthorizationContext.Provider, {
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 10
    }
  }, children);
};
exports.AuthorizationProvider = AuthorizationProvider;