"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextExpansionDismissButton = exports.TextExpansionCallOut = exports.FineTuneModelsButton = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../../shared/kibana");
var _index_view_logic = require("../../../index_view_logic");
var _utils = require("../utils");
var _deploy_model = require("./deploy_model");
var _model_deployed = require("./model_deployed");
var _model_deployment_in_progress = require("./model_deployment_in_progress");
var _model_started = require("./model_started");
var _text_expansion_callout_data = require("./text_expansion_callout_data");
var _text_expansion_callout_logic = require("./text_expansion_callout_logic");
var _text_expansion_errors = require("./text_expansion_errors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/search_index/pipelines/ml_inference/text_expansion_callout/text_expansion_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const TextExpansionDismissButton = ({
  dismiss
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.index.pipelines.textExpansionCallOut.dismissButton', {
      defaultMessage: 'Dismiss ELSER call out'
    }),
    iconType: "cross",
    onClick: dismiss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  });
};
exports.TextExpansionDismissButton = TextExpansionDismissButton;
const FineTuneModelsButton = () => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
  iconSide: "left",
  iconType: "wrench",
  onClick: () => _kibana.KibanaLogic.values.navigateToUrl(_utils.TRAINED_MODELS_PATH, {
    shouldNotCreateHref: true
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 60,
    columnNumber: 3
  }
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.textExpansionCallOut.fineTuneModelButton', {
  defaultMessage: 'Fine-tune performance'
}));
exports.FineTuneModelsButton = FineTuneModelsButton;
const TextExpansionCallOut = props => {
  const {
    dismiss,
    isCompact,
    isDismissable,
    show
  } = (0, _text_expansion_callout_data.useTextExpansionCallOutData)(props);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    isCreateButtonDisabled,
    isModelDownloadInProgress,
    isModelDownloaded,
    isModelRunningSingleThreaded,
    isModelStarted,
    textExpansionError,
    isStartButtonDisabled
  } = (0, _kea.useValues)(_text_expansion_callout_logic.TextExpansionCalloutLogic);
  if (textExpansionError) return /*#__PURE__*/_react.default.createElement(_text_expansion_errors.TextExpansionErrors, {
    error: textExpansionError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 34
    }
  });
  if (!show) return null;
  if (isModelDownloadInProgress) {
    return /*#__PURE__*/_react.default.createElement(_model_deployment_in_progress.ModelDeploymentInProgress, {
      dismiss: dismiss,
      isDismissable: isDismissable,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 12
      }
    });
  } else if (isModelDownloaded) {
    return /*#__PURE__*/_react.default.createElement(_model_deployed.ModelDeployed, {
      dismiss: dismiss,
      ingestionMethod: ingestionMethod,
      isDismissable: isDismissable,
      isStartButtonDisabled: isStartButtonDisabled,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 7
      }
    });
  } else if (isModelStarted) {
    return /*#__PURE__*/_react.default.createElement(_model_started.ModelStarted, {
      dismiss: dismiss,
      isCompact: isCompact,
      isDismissable: isDismissable,
      isSingleThreaded: isModelRunningSingleThreaded,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 108,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_deploy_model.DeployModel, {
    dismiss: dismiss,
    ingestionMethod: ingestionMethod,
    isDismissable: isDismissable,
    isCreateButtonDisabled: isCreateButtonDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 5
    }
  });
};
exports.TextExpansionCallOut = TextExpansionCallOut;