"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DockerInstructionsStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _searchApiPanels = require("@kbn/search-api-panels");
var _cloud_details = require("../../../../shared/cloud_details/cloud_details");
var _constants = require("../../search_index/connector/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/enterprise_search/public/applications/enterprise_search_content/components/connector_detail/components/docker_instructions_step.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DockerInstructionsStep = ({
  connectorId,
  isWaitingForConnector,
  serviceType,
  apiKeyData,
  connectorVersion
}) => {
  const [isOpen, setIsOpen] = _react.default.useState('open');
  const {
    elasticsearchUrl
  } = (0, _cloud_details.useCloudDetails)();
  (0, _react.useEffect)(() => {
    if (!isWaitingForConnector) {
      setIsOpen('closed');
    }
  }, [isWaitingForConnector]);
  const configYamlContent = (0, _constants.getConnectorTemplate)({
    apiKeyData,
    connectorData: {
      id: connectorId,
      service_type: serviceType
    },
    host: elasticsearchUrl
  });
  const escapedConfigYamlContent = configYamlContent.replace(/\\/g, '\\\\').replace(/"/g, '\\"').replace(/\$/g, '\\$');
  const createConfigCommand = `mkdir -p "$HOME/elastic-connectors" && echo "${escapedConfigYamlContent}" > "$HOME/elastic-connectors/config.yml"`;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "collapsibleDocker",
    onToggle: () => setIsOpen(isOpen === 'closed' ? 'open' : 'closed'),
    forceState: isOpen,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.dockerInstructionsHeading', {
      defaultMessage: 'Docker instructions'
    }))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.p.dockerInstallationNote', {
    defaultMessage: 'Make sure you have Docker installed on your machine.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.p.createConfigFileLabel', {
    defaultMessage: 'Create configuration file'
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.p.createConfigFileInstructions', {
    defaultMessage: 'You need a configuration file with your Elasticsearch and connector details. In your terminal, run the following command to create the config.yml file:'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
    showTopBar: false,
    languageType: "bash",
    codeSnippet: createConfigCommand,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.connectorDeployment.p.configFileExplanation",
    defaultMessage: "This command creates a {configFile} file in the {directory} directory with your specific connector and Elasticsearch details.",
    values: {
      configFile: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 115,
          columnNumber: 29
        }
      }, "config.yml"),
      directory: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 28
        }
      }, "$HOME/elastic-connectors")
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.connectorDeployment.p.exampleConfigFile",
    defaultMessage: "If you want to customize settings later, refer to this {exampleConfigLink}.",
    values: {
      exampleConfigLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "enterpriseSearchDockerInstructionsStepExampleConfigFileLink",
        href: "https://github.com/elastic/connectors/blob/main/config.yml.example",
        target: "_blank",
        external: true,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 126,
          columnNumber: 19
        }
      }, _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.exampleConfigLinkText', {
        defaultMessage: 'example config file'
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 145,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h5", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.p.runContainerLabel', {
    defaultMessage: 'Run container'
  })), /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.connectorDeployment.p.runTheFollowingCommandLabel', {
    defaultMessage: 'Run the following command to start the container:'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_searchApiPanels.CodeBox, {
    showTopBar: false,
    languageType: "bash",
    codeSnippet: (0, _constants.getRunFromDockerSnippet)({
      version: connectorVersion
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 161,
      columnNumber: 9
    }
  })));
};
exports.DockerInstructionsStep = DockerInstructionsStep;