"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDissectProcessor = getDissectProcessor;
var _serialize_ast = require("./serialize_ast");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Generates an Elasticsearch Dissect processor configuration from a Dissect pattern.
 *
 * @param pattern - The DissectPattern object containing AST and field metadata
 * @param sourceField - The source field to apply dissect to (default: 'message')
 * @returns DissectProcessorResult with processor config and metadata
 */
function getDissectProcessor(pattern, sourceField = 'message') {
  var _pattern$fields$0$val, _pattern$fields$;
  const patternString = (0, _serialize_ast.serializeAST)(pattern.ast);
  return {
    pattern: patternString,
    processor: {
      dissect: {
        field: sourceField,
        pattern: patternString,
        ignore_missing: true
      }
    },
    metadata: {
      messageCount: (_pattern$fields$0$val = (_pattern$fields$ = pattern.fields[0]) === null || _pattern$fields$ === void 0 ? void 0 : _pattern$fields$.values.length) !== null && _pattern$fields$0$val !== void 0 ? _pattern$fields$0$val : 0,
      delimiterCount: countDelimiters(patternString),
      fieldCount: pattern.fields.length
    }
  };
}

/**
 * Counts the number of delimiter sequences in a pattern
 */
function countDelimiters(pattern) {
  // Count non-%{} sequences
  const withoutFields = pattern.replace(/%\{[^}]+\}/g, '');
  // Count meaningful delimiter sequences (more than just whitespace)
  return withoutFields.split(/\s+/).filter(s => s.length > 0).length;
}