"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogDocumentOverview = getLogDocumentOverview;
var _ = require("../..");
var _get_field_value_with_fallback = require("./get_field_value_with_fallback");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function getLogDocumentOverview(doc, {
  dataView,
  fieldFormats
}) {
  const formatField = field => {
    // Use fallback to check both ECS and OTel field names
    const result = (0, _get_field_value_with_fallback.getFieldValueWithFallback)(doc.flattened, field);
    const value = result.value;
    return value !== undefined && value !== null ? (0, _.formatFieldValue)(value, doc.raw, fieldFormats, dataView, dataView.fields.getByName(field)) : undefined;
  };
  const levelArray = doc.flattened[_.fieldConstants.LOG_LEVEL_FIELD];
  const level = Array.isArray(levelArray) && levelArray.length > 0 ? levelArray[0] : levelArray;
  const message = formatField(_.fieldConstants.MESSAGE_FIELD);
  const errorMessage = formatField(_.fieldConstants.ERROR_MESSAGE_FIELD);
  const eventOriginal = formatField(_.fieldConstants.EVENT_ORIGINAL_FIELD);
  const timestamp = formatField(_.fieldConstants.TIMESTAMP_FIELD);

  // Service
  const serviceName = formatField(_.fieldConstants.SERVICE_NAME_FIELD);
  const traceId = formatField(_.fieldConstants.TRACE_ID_FIELD);
  const transactionId = formatField(_.fieldConstants.TRANSACTION_ID_FIELD);
  const spanId = formatField(_.fieldConstants.SPAN_ID_FIELD);

  // Infrastructure
  const hostname = formatField(_.fieldConstants.HOST_NAME_FIELD);
  const orchestratorClusterName = formatField(_.fieldConstants.ORCHESTRATOR_CLUSTER_NAME_FIELD);
  const orchestratorResourceId = formatField(_.fieldConstants.ORCHESTRATOR_RESOURCE_ID_FIELD);

  // Cloud
  const cloudProvider = formatField(_.fieldConstants.CLOUD_PROVIDER_FIELD);
  const cloudRegion = formatField(_.fieldConstants.CLOUD_REGION_FIELD);
  const cloudAz = formatField(_.fieldConstants.CLOUD_AVAILABILITY_ZONE_FIELD);
  const cloudProjectId = formatField(_.fieldConstants.CLOUD_PROJECT_ID_FIELD);
  const cloudInstanceId = formatField(_.fieldConstants.CLOUD_INSTANCE_ID_FIELD);

  // Other
  const logFilePath = formatField(_.fieldConstants.LOG_FILE_PATH_FIELD);
  const namespace = formatField(_.fieldConstants.DATASTREAM_NAMESPACE_FIELD);
  const dataset = formatField(_.fieldConstants.DATASTREAM_DATASET_FIELD);
  const agentName = formatField(_.fieldConstants.AGENT_NAME_FIELD);

  // apm  log fields
  const errorLogLevel = formatField(_.fieldConstants.ERROR_LOG_LEVEL_FIELD);
  const errorExceptionMessage = formatField(_.fieldConstants.ERROR_EXCEPTION_MESSAGE);
  const processorEvent = formatField(_.fieldConstants.PROCESSOR_EVENT_FIELD);

  // otel log fields
  const eventName = formatField(_.fieldConstants.OTEL_EVENT_NAME_FIELD);

  // exception message
  const exceptionMessage = formatField(_.fieldConstants.EXCEPTION_MESSAGE_FIELD);
  const otelExpectionMessage = formatField(_.fieldConstants.OTEL_ATTRIBUTES_EXCEPTION_MESSAGE);
  const otelExpectionStackTrace = formatField(_.fieldConstants.OTEL_ATTRIBUTES_EXCEPTION_STACKTRACE);
  return {
    [_.fieldConstants.LOG_LEVEL_FIELD]: level,
    [_.fieldConstants.ERROR_LOG_LEVEL_FIELD]: errorLogLevel,
    [_.fieldConstants.TIMESTAMP_FIELD]: timestamp,
    [_.fieldConstants.MESSAGE_FIELD]: message,
    [_.fieldConstants.ERROR_MESSAGE_FIELD]: errorMessage,
    [_.fieldConstants.EVENT_ORIGINAL_FIELD]: eventOriginal,
    [_.fieldConstants.SERVICE_NAME_FIELD]: serviceName,
    [_.fieldConstants.TRACE_ID_FIELD]: traceId,
    [_.fieldConstants.TRANSACTION_ID_FIELD]: transactionId,
    [_.fieldConstants.SPAN_ID_FIELD]: spanId,
    [_.fieldConstants.HOST_NAME_FIELD]: hostname,
    [_.fieldConstants.ORCHESTRATOR_CLUSTER_NAME_FIELD]: orchestratorClusterName,
    [_.fieldConstants.ORCHESTRATOR_RESOURCE_ID_FIELD]: orchestratorResourceId,
    [_.fieldConstants.CLOUD_PROVIDER_FIELD]: cloudProvider,
    [_.fieldConstants.CLOUD_REGION_FIELD]: cloudRegion,
    [_.fieldConstants.CLOUD_AVAILABILITY_ZONE_FIELD]: cloudAz,
    [_.fieldConstants.CLOUD_PROJECT_ID_FIELD]: cloudProjectId,
    [_.fieldConstants.CLOUD_INSTANCE_ID_FIELD]: cloudInstanceId,
    [_.fieldConstants.LOG_FILE_PATH_FIELD]: logFilePath,
    [_.fieldConstants.DATASTREAM_NAMESPACE_FIELD]: namespace,
    [_.fieldConstants.DATASTREAM_DATASET_FIELD]: dataset,
    [_.fieldConstants.AGENT_NAME_FIELD]: agentName,
    [_.fieldConstants.EXCEPTION_MESSAGE_FIELD]: exceptionMessage,
    [_.fieldConstants.OTEL_ATTRIBUTES_EXCEPTION_MESSAGE]: otelExpectionMessage,
    [_.fieldConstants.OTEL_ATTRIBUTES_EXCEPTION_STACKTRACE]: otelExpectionStackTrace,
    [_.fieldConstants.PROCESSOR_EVENT_FIELD]: processorEvent,
    [_.fieldConstants.OTEL_EVENT_NAME_FIELD]: eventName,
    [_.fieldConstants.ERROR_EXCEPTION_MESSAGE]: errorExceptionMessage
  };
}