"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverEBTManager = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _uuid = require("uuid");
var _ebtTools = require("@kbn/ebt-tools");
var _scoped_discover_ebt_manager = require("./scoped_discover_ebt_manager");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class DiscoverEBTManager {
  constructor() {
    (0, _defineProperty2.default)(this, "isCustomContextEnabled", false);
    (0, _defineProperty2.default)(this, "customContext$", void 0);
    (0, _defineProperty2.default)(this, "activeScopedManagerId", void 0);
    (0, _defineProperty2.default)(this, "reportEvent", void 0);
    (0, _defineProperty2.default)(this, "reportPerformanceEvent", void 0);
    (0, _defineProperty2.default)(this, "updateProfilesContextWith", discoverProfiles => {
      if (this.isCustomContextEnabled && this.customContext$ && !(0, _lodash.isEqual)(this.customContext$.getValue().discoverProfiles, discoverProfiles)) {
        this.customContext$.next({
          discoverProfiles
        });
      }
    });
  }
  // https://docs.elastic.dev/telemetry/collection/event-based-telemetry
  initialize({
    core,
    discoverEbtContext$
  }) {
    this.customContext$ = discoverEbtContext$;
    this.reportEvent = core.analytics.reportEvent;
    this.reportPerformanceEvent = eventData => (0, _ebtTools.reportPerformanceMetricEvent)(core.analytics, eventData);
  }
  onDiscoverAppMounted() {
    this.isCustomContextEnabled = true;
  }
  onDiscoverAppUnmounted() {
    this.updateProfilesContextWith([]);
    this.isCustomContextEnabled = false;
    this.activeScopedManagerId = undefined;
  }
  getProfilesContext() {
    var _this$customContext$, _this$customContext$$;
    return (_this$customContext$ = this.customContext$) === null || _this$customContext$ === void 0 ? void 0 : (_this$customContext$$ = _this$customContext$.getValue()) === null || _this$customContext$$ === void 0 ? void 0 : _this$customContext$$.discoverProfiles;
  }
  createScopedEBTManager() {
    const scopedManagerId = (0, _uuid.v4)();
    let scopedDiscoverProfiles = [];
    const withScopedContext = callback => (...params) => {
      var _this$customContext$$2, _this$customContext$2;
      const currentDiscoverProfiles = (_this$customContext$$2 = (_this$customContext$2 = this.customContext$) === null || _this$customContext$2 === void 0 ? void 0 : _this$customContext$2.getValue().discoverProfiles) !== null && _this$customContext$$2 !== void 0 ? _this$customContext$$2 : [];
      this.updateProfilesContextWith(scopedDiscoverProfiles);
      callback(...params);
      this.updateProfilesContextWith(currentDiscoverProfiles);
    };
    const scopedReportEvent = this.reportEvent ? withScopedContext(this.reportEvent) : undefined;
    const scopedReportPerformanceEvent = this.reportPerformanceEvent ? withScopedContext(this.reportPerformanceEvent) : undefined;
    const scopedUpdateProfilesContextWith = discoverProfiles => {
      scopedDiscoverProfiles = discoverProfiles;
      if (this.activeScopedManagerId === scopedManagerId) {
        this.updateProfilesContextWith(discoverProfiles);
      }
    };
    const scopedSetAsActiveManager = () => {
      this.activeScopedManagerId = scopedManagerId;
      this.updateProfilesContextWith(scopedDiscoverProfiles);
    };
    return new _scoped_discover_ebt_manager.ScopedDiscoverEBTManager(scopedReportEvent, scopedReportPerformanceEvent, scopedUpdateProfilesContextWith, scopedSetAsActiveManager);
  }
}
exports.DiscoverEBTManager = DiscoverEBTManager;