"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSavedSearch = exports.DiscoverStateProvider = exports.DiscoverMainProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _redux = require("./redux");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/state_management/discover_state_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function createStateHelpers() {
  const context = /*#__PURE__*/_react.default.createContext(null);
  const useContainer = () => (0, _react.useContext)(context);
  const useSavedSearch = () => {
    const container = useContainer();
    return (0, _useObservable.default)(container.savedSearchState.getCurrent$(), container.savedSearchState.getCurrent$().getValue());
  };
  return {
    Provider: context.Provider,
    useSavedSearch
  };
}
const {
  Provider: DiscoverStateProvider,
  useSavedSearch
} = createStateHelpers();
exports.useSavedSearch = useSavedSearch;
exports.DiscoverStateProvider = DiscoverStateProvider;
const DiscoverMainProvider = ({
  value,
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(DiscoverStateProvider, {
    value: value,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_redux.InternalStateProvider, {
    store: value.internalState,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, children));
};
exports.DiscoverMainProvider = DiscoverMainProvider;