"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getOpenSearchAppMenuItem = void 0;
var _react = _interopRequireDefault(require("react"));
var _discoverUtils = require("@kbn/discover-utils");
var _i18n = require("@kbn/i18n");
var _open_search_panel = require("../open_search_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/discover/public/application/main/components/top_nav/app_menu_actions/get_open_search.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const getOpenSearchAppMenuItem = ({
  onOpenSavedSearch
}) => {
  return {
    id: _discoverUtils.AppMenuActionId.open,
    type: _discoverUtils.AppMenuActionType.primary,
    controlProps: {
      label: _i18n.i18n.translate('discover.localMenu.openDiscoverSessionTitle', {
        defaultMessage: 'Open session'
      }),
      iconType: 'folderOpen',
      testId: 'discoverOpenButton',
      onClick: ({
        onFinishAction
      }) => {
        return /*#__PURE__*/_react.default.createElement(_open_search_panel.OpenSearchPanel, {
          onClose: onFinishAction,
          onOpenSavedSearch: onOpenSavedSearch,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 31,
            columnNumber: 16
          }
        });
      }
    }
  };
};
exports.getOpenSearchAppMenuItem = getOpenSearchAppMenuItem;