"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorState = ErrorState;
exports.LoadingState = LoadingState;
exports.NoDataState = NoDataState;
exports.TIME_LABELS = void 0;
exports.TimeLabelForData = TimeLabelForData;
exports.asPercent = asPercent;
exports.getDomain = void 0;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _chartIcons = require("@kbn/chart-icons");
var _public = require("@kbn/charts-plugin/public");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/rule_types/degraded_docs/rule_form/chart_preview/chart_preview_helper.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function isFiniteNumber(value) {
  return isFinite(value);
}
function asPercent(numerator, denominator, fallbackResult = 'N/A') {
  if (!denominator || !isFiniteNumber(numerator)) {
    return fallbackResult;
  }
  const decimal = numerator / denominator;
  if (Math.abs(decimal) >= 0.1 || decimal === 0) {
    return (0, _numeral.default)(decimal).format('0.000%');
  }
  return (0, _numeral.default)(decimal).format('0.000%');
}
const TIME_LABELS = exports.TIME_LABELS = {
  s: _i18n.i18n.translate('xpack.datasetQuality.alerts.timeLabels.seconds', {
    defaultMessage: 'seconds'
  }),
  m: _i18n.i18n.translate('xpack.datasetQuality.alerts.timeLabels.minutes', {
    defaultMessage: 'minutes'
  }),
  h: _i18n.i18n.translate('xpack.datasetQuality.alerts.timeLabels.hours', {
    defaultMessage: 'hours'
  }),
  d: _i18n.i18n.translate('xpack.datasetQuality.alerts.timeLabels.days', {
    defaultMessage: 'days'
  })
};
const getDomain = series => {
  const xValues = series.flatMap(item => item.data.map(d => d.x));
  const yValues = series.flatMap(item => item.data.map(d => d.y || 0));
  return {
    xMax: Math.max(...xValues),
    xMin: Math.min(...xValues),
    yMax: Math.max(...yValues),
    yMin: Math.min(...yValues)
  };
};
exports.getDomain = getDomain;
const EmptyContainer = ({
  children
}) => /*#__PURE__*/_react.default.createElement("div", {
  style: {
    width: '100%',
    height: 150,
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center'
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 68,
    columnNumber: 3
  }
}, children);
function NoDataState() {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_public.EmptyPlaceholder, {
    icon: _chartIcons.IconChartBar,
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.datasetQuality.chartPreview.noDataMessage",
      defaultMessage: "No results found",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 11
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 7
    }
  }));
}
function LoadingState() {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "loadingData",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 9
    }
  })));
}
function ErrorState() {
  return /*#__PURE__*/_react.default.createElement(EmptyContainer, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "chartErrorState",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.alerts.charts.errorMessage",
    defaultMessage: "Uh oh, something went wrong",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 9
    }
  })));
}
function TimeLabelForData({
  field,
  timeSize,
  timeUnit,
  series,
  totalGroups
}) {
  const totalGroupsTooltip = _i18n.i18n.translate('xpack.datasetQuality.chartPreview.TimeLabelForData.totalGroupsTooltip', {
    defaultMessage: 'Showing {series} out of {totalGroups} groups',
    values: {
      series,
      totalGroups
    }
  });
  const xAxisInfo = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("strong", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.datasetQuality.chartPreview.timeLabelForData.xAxis",
    defaultMessage: "{field} per {timeSize} {timeUnit}",
    values: {
      field,
      timeSize,
      timeUnit: TIME_LABELS[timeUnit]
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  })));
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      textAlign: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 163,
      columnNumber: 5
    }
  }, totalGroups > series ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: totalGroupsTooltip,
    position: "top",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 11
    }
  }, xAxisInfo, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    color: "subdued",
    type: "question",
    className: "eui-alignTop",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 13
    }
  }))) : xAxisInfo);
}