"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoPointContentWithMap = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/maps-plugin/common");
var _expanded_row_content = require("../../stats_table/components/field_data_expanded_row/expanded_row_content");
var _document_stats = require("../../stats_table/components/field_data_expanded_row/document_stats");
var _examples_list = require("../../examples_list");
var _kibana_context = require("../../../../kibana_context");
var _constants = require("../../../../../../common/constants");
var _expanded_row_panel = require("../../stats_table/components/field_data_expanded_row/expanded_row_panel");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/expanded_row/geo_point_content_with_map/geo_point_content_with_map.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const GeoPointContentWithMap = ({
  config,
  dataView,
  combinedQuery,
  esql,
  timeFieldName
}) => {
  const {
    stats
  } = config;
  const [layerList, setLayerList] = (0, _react.useState)([]);
  const {
    services: {
      maps: mapsPlugin,
      data
    }
  } = (0, _kibana_context.useDataVisualizerKibana)();
  const query = (0, _react.useMemo)(() => {
    return combinedQuery ? {
      query: combinedQuery.searchString,
      language: combinedQuery.searchQueryLanguage
    } : undefined;
  }, [combinedQuery]);
  (0, _react.useEffect)(() => {
    if (!mapsPlugin) {
      return;
    }
    if (!(dataView !== null && dataView !== void 0 && dataView.id) || !(config !== null && config !== void 0 && config.fieldName) || !(config.type === _constants.SUPPORTED_FIELD_TYPES.GEO_POINT || config.type === _constants.SUPPORTED_FIELD_TYPES.GEO_SHAPE)) {
      setLayerList([]);
      return;
    }
    let ignore = false;
    mapsPlugin.createLayerDescriptors.createESSearchSourceLayerDescriptor({
      indexPatternId: dataView.id,
      geoFieldName: config.fieldName,
      geoFieldType: config.type
    }).then(searchLayerDescriptor => {
      if (ignore) {
        return;
      }
      if (esql !== undefined) {
        var _dataView$timeFieldNa;
        // Currently, createESSearchSourceLayerDescriptor doesn't support ES|QL yet
        // but we can manually override the source descriptor with the ES|QL ESQLSourceDescriptor
        const esqlSourceDescriptor = {
          columns: [{
            name: config.fieldName,
            type: config.type
          }],
          dataViewId: dataView.id,
          dateField: (_dataView$timeFieldNa = dataView.timeFieldName) !== null && _dataView$timeFieldNa !== void 0 ? _dataView$timeFieldNa : timeFieldName,
          geoField: config.fieldName,
          esql,
          narrowByGlobalSearch: true,
          narrowByGlobalTime: true,
          narrowByMapBounds: true,
          id: searchLayerDescriptor.sourceDescriptor.id,
          type: 'ESQL',
          applyForceRefresh: true
        };
        setLayerList([{
          ...searchLayerDescriptor,
          sourceDescriptor: esqlSourceDescriptor
        }]);
      } else {
        setLayerList([searchLayerDescriptor]);
      }
    }).catch(() => {
      if (!ignore) {
        setLayerList([]);
      }
    });
    return () => {
      ignore = true;
    };
  }, [dataView, combinedQuery, esql, config, mapsPlugin, timeFieldName]);
  if ((stats === null || stats === void 0 ? void 0 : stats.examples) === undefined) return null;
  return /*#__PURE__*/_react.default.createElement(_expanded_row_content.ExpandedRowContent, {
    dataTestSubj: 'dataVisualizerIndexBasedMapContent',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_document_stats.DocumentStatsTable, {
    config: config,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_examples_list.ExamplesList, {
    examples: stats === null || stats === void 0 ? void 0 : stats.examples,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 7
    }
  }), mapsPlugin && /*#__PURE__*/_react.default.createElement(_expanded_row_panel.ExpandedRowPanel, {
    className: 'dvPanel__wrapper dvMap__wrapper',
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(mapsPlugin.Map, {
    layerList: layerList,
    hideFilterActions: true,
    mapSettings: {
      initialLocation: _common.INITIAL_LOCATION.AUTO_FIT_TO_BOUNDS,
      autoFitToDataBounds: true
    },
    filters: data.query.filterManager.getFilters(),
    query: query,
    timeRange: data.query.timefilter.timefilter.getTime(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 11
    }
  })));
};
exports.GeoPointContentWithMap = GeoPointContentWithMap;