"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TotalCountHeader = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _get_data_test_subject = require("../../util/get_data_test_subject");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/common/components/document_count_content/total_count_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const SIGFIGS_IF_ROUNDING = 3; // Number of sigfigs to use for values < 10

const defaultDocCountLabel = _i18n.i18n.translate('xpack.dataVisualizer.searchPanel.totalDocumentsLabel', {
  defaultMessage: 'Total documents'
});
const TotalCountHeader = ({
  id,
  totalCount,
  approximate,
  loading,
  label = defaultDocCountLabel
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      flexDirection: 'row'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    "data-test-subj": (0, _get_data_test_subject.getDataTestSubject)('dataVisualizerTotalDocCountHeader', id),
    textAlign: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.dataVisualizer.searchPanel.totalDocCountLabel",
    defaultMessage: "{label}: {prepend}{strongTotalCount}",
    values: {
      label,
      prepend: !loading && approximate ? '~' : '',
      strongTotalCount: loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 47,
          columnNumber: 15
        }
      }) : /*#__PURE__*/_react.default.createElement("strong", {
        "data-test-subj": (0, _get_data_test_subject.getDataTestSubject)('dataVisualizerTotalDocCount', id),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 49,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.dataVisualizer.searchPanel.totalDocCountNumber",
        defaultMessage: "{totalCount, plural, one {#} other {#}}",
        values: {
          totalCount: approximate ? totalCount.toPrecision(SIGFIGS_IF_ROUNDING) : totalCount
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 17
        }
      }))
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 40,
      columnNumber: 9
    }
  })), approximate ? /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    content: _i18n.i18n.translate('xpack.dataVisualizer.searchPanel.randomSamplerMessage', {
      defaultMessage: 'Approximate values are shown in the total document count and chart, which use random sampler aggregations.'
    }),
    position: "right",
    type: "info",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 9
    }
  }) : null);
};
exports.TotalCountHeader = TotalCountHeader;