"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditIndexPattern = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-views-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _lodash = require("lodash");
var _rollup = require("@kbn/rollup");
var _tabs = require("./tabs");
var _index_header = require("./index_header");
var _state_utils = require("../../management_app/state_utils");
var _data_view_mgmt_selectors = require("../../management_app/data_view_mgmt_selectors");
var _delete_data_view_flyout = require("../delete_data_view_flyout/delete_data_view_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/edit_index_pattern/edit_index_pattern.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const codeStyle = {
  marginLeft: '8px',
  overflowWrap: 'anywhere'
};
const mappingConflictHeader = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.mappingConflictHeader', {
  defaultMessage: 'Mapping conflict'
});
const securityDataView = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.badge.securityDataViewTitle', {
  defaultMessage: 'Security Solution'
});
const securitySolution = 'security-solution';
const getCompositeRuntimeFields = dataView => (0, _lodash.pickBy)(dataView.getAllRuntimeFields(), fld => fld.type === 'composite');
const EditIndexPattern = exports.EditIndexPattern = (0, _reactRouterDom.withRouter)(({
  indexPattern,
  history,
  location
}) => {
  const {
    chrome,
    dataViews,
    IndexPatternEditor,
    dataViewMgmtService
  } = (0, _public2.useKibana)().services;
  const dataView = (0, _state_utils.useStateSelector)(dataViewMgmtService.state$, _data_view_mgmt_selectors.dataViewSelector);
  const allowedTypes = (0, _state_utils.useStateSelector)(dataViewMgmtService.state$, _data_view_mgmt_selectors.allowedTypesSelector);
  const relationships = (0, _state_utils.useStateSelector)(dataViewMgmtService.state$, _data_view_mgmt_selectors.relationshipsSelector);
  const tags = (0, _state_utils.useStateSelector)(dataViewMgmtService.state$, _data_view_mgmt_selectors.tagsSelector);
  const isRefreshing = (0, _state_utils.useStateSelector)(dataViewMgmtService.state$, _data_view_mgmt_selectors.isRefreshingSelector);
  const defaultIndex = (0, _state_utils.useStateSelector)(dataViewMgmtService.state$, _data_view_mgmt_selectors.defaultIndexSelector);
  const fields = (0, _state_utils.useStateSelector)(dataViewMgmtService.state$, _data_view_mgmt_selectors.fieldsSelector);
  const fieldConflictCount = (0, _state_utils.useStateSelector)(dataViewMgmtService.state$, state => state.fieldConflictCount);
  const conflictFieldsUrl = (0, _state_utils.useStateSelector)(dataViewMgmtService.state$, state => state.conflictFieldsUrl);
  // has default
  const [compositeRuntimeFields, setCompositeRuntimeFields] = (0, _react.useState)(() => getCompositeRuntimeFields(indexPattern));
  const [showEditDialog, setShowEditDialog] = (0, _react.useState)(false);
  const [flyoutOpen, setFlyoutOpen] = _react.default.useState(false);

  // subscribe and unsubscribe to hash change events
  (0, _react.useEffect)(() => {
    // dispatch synthetic hash change event to update hash history objects
    // this is necessary because hash updates triggered by using popState won't trigger this event naturally.
    const unlistenParentHistory = history.listen(() => {
      window.dispatchEvent(new HashChangeEvent('hashchange'));
    });
    return () => {
      unlistenParentHistory();
    };
  }, [history]);
  const isRollup = new URLSearchParams((0, _reactRouterDom.useLocation)().search).get('type') === _public.DataViewType.ROLLUP && dataViews.getRollupsEnabled();
  const displayIndexPatternEditor = showEditDialog ? /*#__PURE__*/_react.default.createElement(IndexPatternEditor, {
    onSave: () => {
      dataViewMgmtService.refreshFields();
      setShowEditDialog(false);
    },
    onCancel: () => setShowEditDialog(false),
    defaultTypeIsRollup: isRollup,
    editData: dataView,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 7
    }
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  const editPattern = () => {
    setShowEditDialog(true);
  };
  const indexPatternHeading = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.indexPatternHeading', {
    defaultMessage: 'Index pattern:'
  });
  const timeFilterHeading = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.timeFilterHeading', {
    defaultMessage: 'Time field:'
  });
  const mappingConflictLabel = _i18n.i18n.translate('indexPatternManagement.editIndexPattern.mappingConflictLabel', {
    defaultMessage: '{conflictFieldsLength, plural, one {A field is} other {# fields are}} defined as several types (string, integer, etc) across the indices that match this pattern. You may still be able to use these conflict fields in parts of Kibana, but they will be unavailable for functions that require Kibana to know their type. Correcting this issue will require reindexing your data.',
    values: {
      conflictFieldsLength: fieldConflictCount
    }
  });
  const headingAriaLabel = _i18n.i18n.translate('indexPatternManagement.editDataView.detailsAria', {
    defaultMessage: 'Data view details'
  });
  chrome.docTitle.change(indexPattern.getName());
  const userEditPermission = dataViews.getCanSaveSync();
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "editIndexPattern",
    role: "region",
    "aria-label": headingAriaLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 7
    }
  }, dataView && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_index_header.IndexHeader, {
    indexPattern: dataView,
    setDefault: () => dataViewMgmtService.setDefaultDataView(),
    editIndexPatternClick: editPattern,
    deleteIndexPatternClick: () => {
      setFlyoutOpen(true);
    },
    defaultIndex: defaultIndex,
    canSave: userEditPermission,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 188,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    wrap: true,
    gutterSize: "l",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 189,
      columnNumber: 13
    }
  }, Boolean(indexPattern.title) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 191,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 21
    }
  }, indexPatternHeading), /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    "data-test-subj": "currentIndexPatternTitle",
    style: codeStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 21
    }
  }, indexPattern.title))), Boolean(indexPattern.timeFieldName) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 21
    }
  }, timeFilterHeading), /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    "data-test-subj": "currentIndexPatternTimeField",
    style: codeStyle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 21
    }
  }, indexPattern.timeFieldName))), indexPattern.id && indexPattern.id.indexOf(securitySolution) === 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "accent",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 212,
      columnNumber: 19
    }
  }, securityDataView)), tags.map(tag => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    key: tag.key,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 17
    }
  }, tag.key === 'default' ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "starFilled",
    color: "default",
    "data-test-subj": tag['data-test-subj'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 21
    }
  }, tag.name) : tag.key === 'rollup' ? /*#__PURE__*/_react.default.createElement(_rollup.RollupDeprecationTooltip, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning",
    "data-test-subj": tag['data-test-subj'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 23
    }
  }, tag.name)) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow",
    "data-test-subj": tag['data-test-subj'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 232,
      columnNumber: 21
    }
  }, tag.name)))), fieldConflictCount > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 241,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: false,
    title: mappingConflictHeader,
    color: "warning",
    iconType: "warning",
    "data-test-subj": "dataViewMappingConflict",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 242,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 249,
      columnNumber: 19
    }
  }, mappingConflictLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "viewDataViewMappingConflictsButton",
    href: conflictFieldsUrl,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 250,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('indexPatternManagement.editIndexPattern.viewMappingConflictButton', {
    defaultMessage: 'View conflicts'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 9
    }
  }), dataView && /*#__PURE__*/_react.default.createElement(_tabs.Tabs, {
    indexPattern: dataView,
    saveIndexPattern: dataViews.updateSavedObject.bind(dataViews),
    fields: fields,
    relationships: relationships,
    allowedTypes: allowedTypes,
    history: history,
    location: location,
    compositeRuntimeFields: compositeRuntimeFields,
    refreshFields: () => {
      dataViewMgmtService.refreshFields();
      setCompositeRuntimeFields(getCompositeRuntimeFields(indexPattern));
    },
    refreshIndexPatternClick: () => dataViewMgmtService.refreshFields(),
    isRefreshing: isRefreshing,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 269,
      columnNumber: 11
    }
  }), flyoutOpen && dataView && /*#__PURE__*/_react.default.createElement(_delete_data_view_flyout.DeleteDataViewFlyout, {
    dataViews: dataViews,
    dataViewArray: [dataView],
    selectedRelationships: {
      [dataView.id]: relationships
    },
    hasSpaces: Boolean(dataView.namespaces),
    onDelete: () => {
      history.push('');
    },
    onClose: () => {
      setFlyoutOpen(false);
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 11
    }
  }), displayIndexPatternEditor);
});