"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isMetricType = exports.isDefaultMetricType = exports.METRIC_TYPE_VALUES = exports.METRIC_TYPE_UI_OPTIONS_VALUES_TO_API_MAP = exports.METRIC_TYPE_API_VALUES_TO_UI_OPTIONS_MAP = exports.DEFAULT_METRIC_TYPES = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// note these should be sorted alphabetically as we sort the URL params on the browser side
// before making the request, else the cache key will be different and that would invoke a new request
const DEFAULT_METRIC_TYPES = exports.DEFAULT_METRIC_TYPES = ['ingest_rate', 'storage_retained'];
const METRIC_TYPE_VALUES = exports.METRIC_TYPE_VALUES = [...DEFAULT_METRIC_TYPES, 'search_vcu', 'ingest_vcu', 'ml_vcu', 'index_latency', 'index_rate', 'search_latency', 'search_rate'];
const isDefaultMetricType = metricType =>
// @ts-ignore
DEFAULT_METRIC_TYPES.includes(metricType);
exports.isDefaultMetricType = isDefaultMetricType;
const METRIC_TYPE_API_VALUES_TO_UI_OPTIONS_MAP = exports.METRIC_TYPE_API_VALUES_TO_UI_OPTIONS_MAP = Object.freeze({
  ingest_rate: 'Data Ingested',
  storage_retained: 'Data Retained in Storage',
  search_vcu: 'Search VCU',
  ingest_vcu: 'Ingest VCU',
  ml_vcu: 'ML VCU',
  index_latency: 'Index Latency',
  index_rate: 'Index Rate',
  search_latency: 'Search Latency',
  search_rate: 'Search Rate'
});
const METRIC_TYPE_UI_OPTIONS_VALUES_TO_API_MAP = exports.METRIC_TYPE_UI_OPTIONS_VALUES_TO_API_MAP = Object.freeze({
  'Data Ingested': 'ingest_rate',
  'Data Retained in Storage': 'storage_retained',
  'Search VCU': 'search_vcu',
  'Ingest VCU': 'ingest_vcu',
  'ML VCU': 'ml_vcu',
  'Index Latency': 'index_latency',
  'Index Rate': 'index_rate',
  'Search Latency': 'search_latency',
  'Search Rate': 'search_rate'
});

// type guard for MetricTypes
const isMetricType = type => METRIC_TYPE_VALUES.includes(type);
exports.isMetricType = isMetricType;