"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDeleteRoute = registerDeleteRoute;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../constants");
var _delete = require("./delete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function registerDeleteRoute(router) {
  const deleteRoute = router.delete({
    path: `${_constants.PUBLIC_API_PATH}/{id}`,
    summary: `Delete a dashboard`,
    ..._constants.commonRouteConfig
  });
  deleteRoute.addVersion({
    version: _constants.INTERNAL_API_VERSION,
    validate: {
      request: {
        params: _configSchema.schema.object({
          id: _configSchema.schema.string({
            meta: {
              description: 'A unique identifier for the dashboard.'
            }
          })
        })
      }
    }
  }, async (ctx, req, res) => {
    try {
      await (0, _delete.deleteDashboard)(ctx, req.params.id);
    } catch (e) {
      if (e.isBoom && e.output.statusCode === 404) {
        return res.notFound({
          body: {
            message: `A dashboard with ID ${req.params.id} was not found.`
          }
        });
      }
      if (e.isBoom && e.output.statusCode === 403) {
        return res.forbidden();
      }
      return res.badRequest();
    }
    return res.ok();
  });
}