"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FatalErrorScreen = FatalErrorScreen;
var _react = require("react");
var _rxjs = require("rxjs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function FatalErrorScreen({
  children,
  error$
}) {
  const [errors, setErrors] = (0, _react.useState)([]);
  const handleReload = (0, _react.useCallback)(() => window.location.reload(), []);
  (0, _react.useEffect)(() => {
    window.addEventListener('hashchange', handleReload);
    return () => window.removeEventListener('hashchange', handleReload);
  }, [handleReload]);
  (0, _react.useEffect)(() => {
    const subscription = error$.pipe((0, _rxjs.scan)((acc, error) => [...acc, error], [])).subscribe(setErrors);
    return () => subscription.unsubscribe();
  }, [error$]);
  return children(errors);
}