"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useContainer = exports.Context = void 0;
exports.useService = useService;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * The React context to provide the dependency injection container.
 * @public
 */
const Context = exports.Context = /*#__PURE__*/(0, _react.createContext)(undefined);
Context.displayName = 'KbnDiContainerContext';

/**
 * The `useContainer` hook is used to retrieve the dependency injection container from the context.
 * @see {@link Container}
 * @public
 */
const useContainer = () => (0, _react.useContext)(Context);

/**
 * The `useService` hook is used to retrieve a service from the dependency injection container.
 * @see {@link Container.get}
 * @param service The service identifier to resolve.
 * @param options InverisfyJS options to pass to the `get` method.
 * @public
 */

/**
 * The `useService` hook is used to retrieve a service from the dependency injection container.
 * @see {@link Container.get}
 * @param service The service identifier to resolve.
 * @param options InverisfyJS options to pass to the `get` method.
 * @public
 */
exports.useContainer = useContainer;
/** @internal */
function useService(...params) {
  const container = useContainer();
  if (!container) {
    throw new Error('The dependency injection container is not provided in the context.');
  }

  // eslint-disable-next-line react-hooks/exhaustive-deps
  return (0, _react.useMemo)(() => container.get(...params), [container, ...params]);
}