"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Header = Header;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _collapsible_nav = require("./collapsible_nav");
var _header_badge = require("./header_badge");
var _header_breadcrumbs = require("./header_breadcrumbs");
var _header_help_menu = require("./header_help_menu");
var _header_logo = require("./header_logo");
var _header_nav_controls = require("./header_nav_controls");
var _header_action_menu = require("./header_action_menu");
var _breadcrumbs_with_extensions = require("./breadcrumbs_with_extensions");
var _header_top_banner = require("./header_top_banner");
var _header_menu_button = require("./header_menu_button");
var _header_page_announcer = require("./header_page_announcer");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/ui/header/header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function Header({
  kibanaVersion,
  kibanaDocLink,
  docLinks,
  application,
  basePath,
  homeHref,
  breadcrumbsAppendExtensions$,
  globalHelpExtensionMenuLinks$,
  customBranding$,
  isServerless,
  isFixed,
  ...observables
}) {
  const [isNavOpen, setIsNavOpen] = (0, _react.useState)(false);
  const [navId] = (0, _react.useState)((0, _eui.htmlIdGenerator)()());
  const headerActionMenuMounter = (0, _header_action_menu.useHeaderActionMenuMounter)(application.currentActionMenu$);
  const toggleCollapsibleNavRef = /*#__PURE__*/(0, _react.createRef)();
  const className = (0, _classnames.default)('hide-for-sharing', 'headerGlobalNav');
  const Breadcrumbs = /*#__PURE__*/_react.default.createElement(_header_breadcrumbs.HeaderBreadcrumbs, {
    breadcrumbs$: observables.breadcrumbs$,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 23
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, observables.headerBanner$ && /*#__PURE__*/_react.default.createElement(_header_top_banner.HeaderTopBanner, {
    headerBanner$: observables.headerBanner$,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 37
    }
  }), /*#__PURE__*/_react.default.createElement("header", {
    className: className,
    "data-test-subj": "headerGlobalNav",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    id: "globalHeaderBars",
    className: "header__bars",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeader, {
    theme: "dark",
    position: isFixed ? 'fixed' : 'static',
    className: "header__firstBar",
    sections: [{
      items: [/*#__PURE__*/_react.default.createElement(_header_page_announcer.HeaderPageAnnouncer, {
        breadcrumbs$: observables.breadcrumbs$,
        customBranding$: customBranding$,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 114,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_header_logo.HeaderLogo, {
        href: homeHref,
        forceNavigation$: observables.forceAppSwitcherNavigation$,
        navLinks$: observables.navLinks$,
        navigateToApp: application.navigateToApp,
        loadingCount$: observables.loadingCount$,
        customBranding$: customBranding$,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 19
        }
      })]
    }, {
      ...(observables.navControlsCenter$ && {
        items: [/*#__PURE__*/_react.default.createElement(_eui.EuiShowFor, {
          sizes: ['m', 'l', 'xl'],
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 131,
            columnNumber: 21
          }
        }, /*#__PURE__*/_react.default.createElement(_header_nav_controls.HeaderNavControls, {
          navControls$: observables.navControlsCenter$,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 132,
            columnNumber: 23
          }
        }))]
      })
    }, {
      items: [/*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
        sizes: ['m', 'l', 'xl'],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 139,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header_nav_controls.HeaderNavControls, {
        navControls$: observables.navControlsExtension$,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 141,
          columnNumber: 23
        }
      }), /*#__PURE__*/_react.default.createElement(_header_nav_controls.HeaderNavControls, {
        navControls$: observables.navControlsCenter$,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 142,
          columnNumber: 23
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
        sizes: ['xs', 's'],
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 19
        }
      }, /*#__PURE__*/_react.default.createElement(_header_nav_controls.HeaderNavControls, {
        navControls$: observables.navControlsExtension$,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 21
        }
      })), /*#__PURE__*/_react.default.createElement(_header_help_menu.HeaderHelpMenu, {
        isServerless: isServerless,
        globalHelpExtensionMenuLinks$: globalHelpExtensionMenuLinks$,
        helpExtension$: observables.helpExtension$,
        helpSupportUrl$: observables.helpSupportUrl$,
        defaultContentLinks$: observables.helpMenuLinks$,
        kibanaDocLink: kibanaDocLink,
        docLinks: docLinks,
        kibanaVersion: kibanaVersion,
        navigateToUrl: application.navigateToUrl,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 19
        }
      }), /*#__PURE__*/_react.default.createElement(_header_nav_controls.HeaderNavControls, {
        navControls$: observables.navControlsRight$,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 159,
          columnNumber: 19
        }
      })]
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHeader, {
    position: isFixed ? 'fixed' : 'static',
    className: "header__secondBar",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSection, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, {
    className: "header__toggleNavButtonSection",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 167,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_collapsible_nav.CollapsibleNav, {
    appId$: application.currentAppId$,
    id: navId,
    navLinks$: observables.navLinks$,
    recentlyAccessed$: observables.recentlyAccessed$,
    isNavOpen: isNavOpen,
    homeHref: homeHref,
    basePath: basePath,
    navigateToApp: application.navigateToApp,
    navigateToUrl: application.navigateToUrl,
    closeNav: () => {
      setIsNavOpen(false);
    },
    customNavLink$: observables.customNavLink$,
    button: /*#__PURE__*/_react.default.createElement(_header_menu_button.HeaderMenuButton, {
      "data-test-subj": "toggleNavButton",
      "aria-label": _i18n.i18n.translate('core.ui.primaryNav.header.toggleNavAriaLabel', {
        defaultMessage: 'Toggle primary navigation'
      }),
      onClick: () => setIsNavOpen(!isNavOpen),
      "aria-expanded": isNavOpen,
      "aria-pressed": isNavOpen,
      "aria-controls": navId,
      forwardRef: toggleCollapsibleNavRef,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 21
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_header_nav_controls.HeaderNavControls, {
    side: "left",
    navControls$: observables.navControlsLeft$,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 198,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_breadcrumbs_with_extensions.BreadcrumbsWithExtensionsWrapper, {
    breadcrumbsAppendExtensions$: breadcrumbsAppendExtensions$,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 13
    }
  }, Breadcrumbs), /*#__PURE__*/_react.default.createElement(_header_badge.HeaderBadge, {
    badge$: observables.badge$,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSection, {
    side: "right",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 209,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 210,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_header_action_menu.HeaderActionMenu, {
    mounter: headerActionMenuMounter,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 211,
      columnNumber: 17
    }
  })))))));
}