"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSyncRules = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _codeEditor = require("@kbn/code-editor");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _sync_rules_helpers = require("../../../../utils/sync_rules_helpers");
var _connector_filtering_logic = require("./connector_filtering_logic");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/search_index/connector/sync_rules/advanced_sync_rules.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AdvancedSyncRules = () => {
  const {
    services: {
      http
    }
  } = (0, _public.useKibana)();
  const {
    hasJsonValidationError: hasError,
    localAdvancedSnippet,
    advancedSnippet
  } = (0, _kea.useValues)((0, _connector_filtering_logic.ConnectorFilteringLogic)({
    http
  }));
  const {
    setLocalAdvancedSnippet
  } = (0, _kea.useActions)((0, _connector_filtering_logic.ConnectorFilteringLogic)({
    http
  }));
  const isAdvancedSnippetEmpty = (0, _sync_rules_helpers.isAdvancedSyncRuleSnippetEmpty)(advancedSnippet);
  const isLocalSnippetEmpty = (0, _sync_rules_helpers.isAdvancedSyncRuleSnippetEmpty)(localAdvancedSnippet);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.contentConnectors.content.indices.connector.syncRules.advancedRules.title', {
      defaultMessage: 'Advanced rules'
    }),
    isInvalid: hasError,
    error: hasError ? _i18n.i18n.translate('xpack.contentConnectors.content.indices.connector.syncRules.advancedRules.error', {
      defaultMessage: 'JSON format is invalid'
    }) : undefined,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    isCopyable: true,
    languageId: "json",
    options: {
      detectIndentation: true,
      lineNumbers: 'on',
      tabSize: 2
    },
    value: localAdvancedSnippet,
    onChange: value => {
      setLocalAdvancedSnippet(value);
    },
    height: "250px",
    width: "100%",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 9
    }
  })), (!isAdvancedSnippetEmpty || !isLocalSnippetEmpty) && /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.contentConnectors.content.index.connector.syncRules.advancedTabCallout.title', {
      defaultMessage: 'Configuration warning'
    }),
    color: "warning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.contentConnectors..editSyncRulesFlyout.advancedTablCallout.description",
    defaultMessage: "This advanced sync rule might override some configuration fields.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }))));
};
exports.AdvancedSyncRules = AdvancedSyncRules;