"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RETRY_TIMEOUT_AND_RATE_LIMIT = exports.RETRY_SERVER_ERRORS = exports.RETRY_RATE_LIMIT = exports.RETRY_GATEWAY_ERRORS = void 0;
Object.defineProperty(exports, "UISchemas", {
  enumerable: true,
  get: function () {
    return _connector_spec_ui.UISchemas;
  }
});
exports.createI18nKeys = createI18nKeys;
exports.getActionNames = getActionNames;
exports.isToolAction = isToolAction;
exports.requiresCredentials = requiresCredentials;
exports.supportsStreaming = supportsStreaming;
var _connector_spec_ui = require("./connector_spec_ui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Stack Connectors 2.0 - Minimal TypeScript Specification
 *
 * This is a simplified spec containing only features used by example connectors.
 * For the comprehensive specification, see connector_rfc.ts
 *
 * Key principles:
 * - Single schema (config + secrets together)
 * - Standard auth types
 * - Secrets marked with meta.sensitive
 * - Standard auth schemas (reusable)
 * - Zod for validation and UI derivation
 */

// ============================================================================
// INTERNATIONALIZATION
// ============================================================================

function createI18nKeys(connectorId) {
  const base = `xpack.stackConnectors${connectorId}`;
  return {
    metadata: key => `${base}.metadata.${key}`,
    config: key => `${base}.config.${key}`,
    secrets: key => `${base}.secrets.${key}`,
    actions: (actionName, key) => `${base}.actions.${actionName}.${key}`,
    validation: key => `${base}.validation.${key}`,
    test: key => `${base}.test.${key}`
  };
}

// ============================================================================
// METADATA
// ============================================================================

// ============================================================================
// STANDARD AUTH SCHEMAS - PHASE 1
// ============================================================================
// Phase 1 supports only: Header, Basic, Bearer
// OAuth2, SSL/mTLS, AWS SigV4 → Phase 2 (see connector_rfc.ts)

// Auth schemas defined in ./auth_types

// ============================================================================
// PHASE 2 AUTH TYPES (Not supported yet - see connector_rfc.ts)
// ============================================================================
// - OAuth2 (clientId, clientSecret, token refresh)
// - SSL/mTLS (certificate-based authentication)
// - AWS SigV4 (AWS service authentication)
// - Custom (connector-specific auth flows)

// ============================================================================
// POLICIES
// ============================================================================

const RETRY_RATE_LIMIT = exports.RETRY_RATE_LIMIT = [429, 503];
const RETRY_SERVER_ERRORS = exports.RETRY_SERVER_ERRORS = [500, 502, 503, 504];
const RETRY_GATEWAY_ERRORS = exports.RETRY_GATEWAY_ERRORS = [502, 503, 504];
const RETRY_TIMEOUT_AND_RATE_LIMIT = exports.RETRY_TIMEOUT_AND_RATE_LIMIT = [408, 429, 503];

// ============================================================================
// ACTIONS
// ============================================================================

// ============================================================================
// TRANSFORMATIONS
// ============================================================================

// ============================================================================
// TESTING
// ============================================================================

// ============================================================================
// MAIN CONNECTOR DEFINITION
// ============================================================================

// ============================================================================
// HELPER UTILITIES
// ============================================================================

function requiresCredentials(auth) {
  return auth.method !== 'none' && auth.method !== 'webhook';
}
function supportsStreaming(connector) {
  var _connector$policies$s, _connector$policies, _connector$policies$s2;
  return (_connector$policies$s = (_connector$policies = connector.policies) === null || _connector$policies === void 0 ? void 0 : (_connector$policies$s2 = _connector$policies.streaming) === null || _connector$policies$s2 === void 0 ? void 0 : _connector$policies$s2.enabled) !== null && _connector$policies$s !== void 0 ? _connector$policies$s : false;
}
function getActionNames(connector) {
  return Object.keys(connector.actions);
}
function isToolAction(connector, actionName) {
  var _connector$actions$ac, _connector$actions$ac2;
  return (_connector$actions$ac = (_connector$actions$ac2 = connector.actions[actionName]) === null || _connector$actions$ac2 === void 0 ? void 0 : _connector$actions$ac2.isTool) !== null && _connector$actions$ac !== void 0 ? _connector$actions$ac : false;
}