"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Rules = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _cloud_posture_page_title = require("../../components/cloud_posture_page_title");
var _rules_container = require("./rules_container");
var _constants = require("../../common/navigation/constants");
var _cloud_posture_page = require("../../components/cloud_posture_page");
var _security_solution_context = require("../../application/security_solution_context");
var _use_csp_benchmark_integrations = require("../benchmarks/use_csp_benchmark_integrations");
var _cis_benchmark_icon = require("../../components/cis_benchmark_icon");
var _helpers = require("../../../common/utils/helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/rules/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Rules = ({
  match: {
    params
  }
}) => {
  var _useSecuritySolutionC;
  const benchmarksInfo = (0, _use_csp_benchmark_integrations.useCspBenchmarkIntegrationsV2)();
  const SpyRoute = (_useSecuritySolutionC = (0, _security_solution_context.useSecuritySolutionContext)()) === null || _useSecuritySolutionC === void 0 ? void 0 : _useSecuritySolutionC.getSpyRouteComponent();
  return /*#__PURE__*/_react.default.createElement(_cloud_posture_page.CloudPosturePage, {
    query: benchmarksInfo,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    alignItems: 'bottom',
    bottomBorder: true,
    pageTitle: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "none",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 33,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: {
        width: 'fit-content'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 34,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Link, {
      to: (0, _reactRouterDom.generatePath)(_constants.cloudPosturePages.benchmarks.path),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "arrowLeft",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 36,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.csp.rules.rulesPageHeader.benchmarkRulesButtonLabel",
      defaultMessage: "Benchmarks",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 19
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      css: {
        marginBottom: 6
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_cis_benchmark_icon.CISBenchmarkIcon, {
      type: params.benchmarkId,
      size: 'l',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 19
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_cloud_posture_page_title.CloudPosturePageTitle, {
      title: _i18n.i18n.translate('xpack.csp.rules.rulePageHeader.pageHeaderTitle', {
        defaultMessage: '{benchmarkName} {benchmarkVersion} - Rules',
        values: {
          benchmarkName: (0, _helpers.getBenchmarkCisName)(params.benchmarkId),
          benchmarkVersion: params.benchmarkVersion
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 19
      }
    }))))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_rules_container.RulesContainer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }), SpyRoute && /*#__PURE__*/_react.default.createElement(SpyRoute, {
    pageName: _constants.cloudPosturePages.benchmarks.id,
    state: {
      ruleName: (0, _helpers.getBenchmarkCisName)(params.benchmarkId)
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 9
    }
  }));
};
exports.Rules = Rules;