"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IntegrationPageRouteCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _eui = require("@elastic/eui");
var _constants = require("../../common/constants");
var _use_add_integrations_route = require("../common/api/use_add_integrations_route");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/integration_page_route_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const INTEGRATION_CALLOUT_TITLE_MISCONFIGURATION = _i18n.i18n.translate('xpack.csp.findings.integrationCalloutMisconfiguration.title', {
  defaultMessage: 'Ingest misconfiguration data to help you analyze, hunt, and investigate threats by providing contextual insights across your infrastructure'
});
const INTEGRATION_CALLOUT_TITLE_VULNERABILITY = _i18n.i18n.translate('xpack.csp.findings.integrationCalloutVulnerability.title', {
  defaultMessage: 'Ingest data from your existing vulnerability solutions for centralized analytics, hunting, investigations, visualizations, and contextual insights across your entire infrastructure'
});
const IntegrationPageRouteCallout = ({
  workflowName
}) => {
  const [userHasDismissedCallout, setUserHasDismissedCallout] = (0, _useLocalStorage.default)(_constants.LOCAL_STORAGE_INTEGRATIONS_PAGE_ROUTE_CALLOUT_KEY + workflowName);
  const addIntegrationRouteLink = (0, _use_add_integrations_route.useAddIntegrationRoute)(workflowName);
  if (userHasDismissedCallout) return null;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: workflowName === 'misconfiguration_workflow' ? INTEGRATION_CALLOUT_TITLE_MISCONFIGURATION : INTEGRATION_CALLOUT_TITLE_VULNERABILITY,
    iconType: "cheer",
    onDismiss: () => setUserHasDismissedCallout(true),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    href: addIntegrationRouteLink,
    target: "_blank",
    color: "primary",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.csp.findings.3pIntegrationsCallout.addIntegrationButton', {
    defaultMessage: 'Add Integration'
  })))));
};
exports.IntegrationPageRouteCallout = IntegrationPageRouteCallout;