"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isOwner = exports.getMarkdownEditorStorageKey = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getMarkdownEditorStorageKey = ({
  caseId,
  commentId,
  appId
}) => {
  const appIdKey = appId && appId !== '' ? appId : 'cases';
  const caseIdKey = caseId !== '' ? caseId : 'case';
  const commentIdKey = commentId !== '' ? commentId : 'comment';
  return `cases.${appIdKey}.${caseIdKey}.${commentIdKey}.markdownEditor`;
};
exports.getMarkdownEditorStorageKey = getMarkdownEditorStorageKey;
const validOwners = new Set(_constants.OWNERS);
const isOwner = o => validOwners.has(o);
exports.isOwner = isOwner;