"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_delete_action = require("../actions/delete/use_delete_action");
var _confirm_delete_case = require("../confirm_delete_case");
var _use_status_action = require("../actions/status/use_status_action");
var _use_on_refresh_cases = require("./use_on_refresh_cases");
var i18n = _interopRequireWildcard(require("./translations"));
var _status = require("../status");
var _use_cases_context = require("../cases_context/use_cases_context");
var _use_severity_action = require("../actions/severity/use_severity_action");
var _config = require("../severity/config");
var _use_tags_action = require("../actions/tags/use_tags_action");
var _edit_tags_flyout = require("../actions/tags/edit_tags_flyout");
var _use_assignees_action = require("../actions/assignees/use_assignees_action");
var _edit_assignees_flyout = require("../actions/assignees/edit_assignees_flyout");
var _use_copy_id_action = require("../actions/copy_id/use_copy_id_action");
var _use_should_disable_status = require("../actions/status/use_should_disable_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/all_cases/use_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ActionColumnComponent = ({
  theCase,
  disableActions
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const tooglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(!isPopoverOpen), [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const refreshCases = (0, _use_on_refresh_cases.useRefreshCases)();
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const buttonRef = _react.default.useRef(null);
  const shouldDisable = (0, _use_should_disable_status.useShouldDisableStatus)();
  const shouldDisableStatus = (0, _react.useMemo)(() => {
    return shouldDisable([theCase]);
  }, [theCase, shouldDisable]);
  const deleteAction = (0, _use_delete_action.useDeleteAction)({
    isDisabled: false,
    onAction: closePopover,
    onActionSuccess: refreshCases
  });
  const copyIDAction = (0, _use_copy_id_action.useCopyIDAction)({
    onActionSuccess: closePopover
  });
  const statusAction = (0, _use_status_action.useStatusAction)({
    isDisabled: false,
    onAction: closePopover,
    onActionSuccess: refreshCases,
    selectedStatus: theCase.status
  });
  const severityAction = (0, _use_severity_action.useSeverityAction)({
    isDisabled: false,
    onAction: closePopover,
    onActionSuccess: refreshCases,
    selectedSeverity: theCase.severity
  });
  const tagsAction = (0, _use_tags_action.useTagsAction)({
    isDisabled: false,
    onAction: closePopover,
    onActionSuccess: refreshCases
  });
  const assigneesAction = (0, _use_assignees_action.useAssigneesAction)({
    isDisabled: false,
    onAction: closePopover,
    onActionSuccess: refreshCases
  });
  const canDelete = deleteAction.canDelete;
  const canUpdate = statusAction.canUpdateStatus;
  const canAssign = permissions.assign;
  const panels = (0, _react.useMemo)(() => {
    const mainPanelItems = [];
    const panelsToBuild = [{
      id: 0,
      items: mainPanelItems,
      title: i18n.ACTIONS
    }];
    if (!shouldDisableStatus) {
      var _statuses$theCase$sta, _statuses$theCase$sta2;
      mainPanelItems.push({
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          defaultMessage: "Status: {status}",
          id: "xpack.cases.allCasesView.statusWithValue",
          values: {
            status: /*#__PURE__*/_react.default.createElement("b", {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 102,
                columnNumber: 31
              }
            }, (_statuses$theCase$sta = (_statuses$theCase$sta2 = _status.statuses[theCase.status]) === null || _statuses$theCase$sta2 === void 0 ? void 0 : _statuses$theCase$sta2.label) !== null && _statuses$theCase$sta !== void 0 ? _statuses$theCase$sta : '-')
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 99,
            columnNumber: 11
          }
        }),
        panel: 1,
        disabled: !canUpdate,
        key: `case-action-status-panel-${theCase.id}`,
        'data-test-subj': `case-action-status-panel-${theCase.id}`
      });
    }
    if (severityAction.canUpdateSeverity) {
      var _severities$theCase$s, _severities$theCase$s2;
      mainPanelItems.push({
        name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          defaultMessage: "Severity: {severity}",
          id: "xpack.cases.allCasesView.severityWithValue",
          values: {
            severity: /*#__PURE__*/_react.default.createElement("b", {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 117,
                columnNumber: 33
              }
            }, (_severities$theCase$s = (_severities$theCase$s2 = _config.severities[theCase.severity]) === null || _severities$theCase$s2 === void 0 ? void 0 : _severities$theCase$s2.label) !== null && _severities$theCase$s !== void 0 ? _severities$theCase$s : '-')
          },
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 114,
            columnNumber: 11
          }
        }),
        panel: 2,
        disabled: !canUpdate,
        key: `case-action-severity-panel-${theCase.id}`,
        'data-test-subj': `case-action-severity-panel-${theCase.id}`
      });
    }

    /**
     * A separator is added if a) there is one item above
     * and b) there is an item below. For this to happen the
     * user has to have delete and update permissions
     */
    if (canUpdate && canDelete) {
      mainPanelItems.push({
        isSeparator: true,
        key: `actions-separator-${theCase.id}`,
        'data-test-subj': `actions-separator-${theCase.id}`
      });
    }
    if (canUpdate) {
      mainPanelItems.push(tagsAction.getAction([theCase]));
    }
    if (canAssign) {
      mainPanelItems.push(assigneesAction.getAction([theCase]));
    }
    mainPanelItems.push(copyIDAction.getAction(theCase));
    if (canDelete) {
      mainPanelItems.push(deleteAction.getAction([theCase]));
    }
    if (statusAction.canUpdateStatus || !shouldDisableStatus) {
      panelsToBuild.push({
        id: 1,
        title: i18n.STATUS,
        items: statusAction.getActions([theCase])
      });
    }
    if (severityAction.canUpdateSeverity) {
      panelsToBuild.push({
        id: 2,
        title: i18n.SEVERITY,
        items: severityAction.getActions([theCase])
      });
    }
    return panelsToBuild;
  }, [assigneesAction, canDelete, canAssign, canUpdate, copyIDAction, deleteAction, severityAction, statusAction, tagsAction, theCase, shouldDisableStatus]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: `case-action-popover-${theCase.id}`,
    key: `case-action-popover-${theCase.id}`,
    "data-test-subj": `case-action-popover-${theCase.id}`,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: tooglePopover,
      iconType: "boxesHorizontal",
      "aria-label": i18n.ACTIONS_BUTTON_ARIA_LABEL(theCase.title),
      color: "text",
      key: `case-action-popover-button-${theCase.id}`,
      "data-test-subj": `case-action-popover-button-${theCase.id}`,
      disabled: disableActions,
      buttonRef: buttonRef,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 11
      }
    }),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    key: `case-action-menu-${theCase.id}`,
    "data-test-subj": `case-action-menu-${theCase.id}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 9
    }
  })), deleteAction.isModalVisible ? /*#__PURE__*/_react.default.createElement(_confirm_delete_case.ConfirmDeleteCaseModal, {
    totalCasesToBeDeleted: 1,
    onCancel: deleteAction.onCloseModal,
    onConfirm: deleteAction.onConfirmDeletion,
    focusButtonRef: buttonRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 215,
      columnNumber: 9
    }
  }) : null, tagsAction.isFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_edit_tags_flyout.EditTagsFlyout, {
    onClose: tagsAction.onFlyoutClosed,
    selectedCases: [theCase],
    onSaveTags: tagsAction.onSaveTags,
    focusButtonRef: buttonRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 9
    }
  }) : null, assigneesAction.isFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_edit_assignees_flyout.EditAssigneesFlyout, {
    onClose: assigneesAction.onFlyoutClosed,
    selectedCases: [theCase],
    onSaveAssignees: assigneesAction.onSaveAssignees,
    focusButtonRef: buttonRef,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 231,
      columnNumber: 9
    }
  }) : null);
};
ActionColumnComponent.displayName = 'ActionColumnComponent';
const ActionColumn = /*#__PURE__*/_react.default.memo(ActionColumnComponent);
const useActions = ({
  disableActions
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const shouldShowActions = permissions.update || permissions.delete || permissions.reopenCase || permissions.assign;
  return {
    actions: shouldShowActions ? {
      name: i18n.ACTIONS,
      align: 'right',
      render: theCase => {
        return /*#__PURE__*/_react.default.createElement(ActionColumn, {
          theCase: theCase,
          key: theCase.id,
          disableActions: disableActions,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 266,
            columnNumber: 15
          }
        });
      },
      width: '100px'
    } : null
  };
};
exports.useActions = useActions;