"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.findExpressionType = findExpressionType;
var _transform_registry = require("../expression_types/transform_registry");
var _model_registry = require("../expression_types/model_registry");
var _view_registry = require("../expression_types/view_registry");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const expressionTypes = ['view', 'model', 'transform', 'datasource'];
function findExpressionType(name, type) {
  const checkTypes = expressionTypes.filter(expressionType => type == null || expressionType === type);
  const matches = checkTypes.reduce((acc, checkType) => {
    let expression;
    switch (checkType) {
      case 'view':
        expression = _view_registry.viewRegistry.get(name);
        return !expression ? acc : acc.concat(expression);
      case 'model':
        expression = _model_registry.modelRegistry.get(name);
        return !expression ? acc : acc.concat(expression);
      case 'transform':
        expression = _transform_registry.transformRegistry.get(name);
        return !expression ? acc : acc.concat(expression);
      default:
        return acc;
    }
  }, []);
  if (matches.length > 1) {
    throw new Error(`Found multiple expressions with name "${name}"`);
  }
  return matches[0] || null;
}