"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomInterval = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _time_interval = require("../../../lib/time_interval");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831386263246/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/workpad_header/view_menu/custom_interval.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getButtonLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderCustomInterval.confirmButtonLabel', {
    defaultMessage: 'Set'
  }),
  getFormDescription: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderCustomInterval.formDescription', {
    defaultMessage: 'Use shorthand notation, like {secondsExample}, {minutesExample}, or {hoursExample}',
    values: {
      secondsExample: '30s',
      minutesExample: '10m',
      hoursExample: '1h'
    }
  }),
  getFormLabel: () => _i18n.i18n.translate('xpack.canvas.workpadHeaderCustomInterval.formLabel', {
    defaultMessage: 'Set a custom interval'
  })
};
const CustomInterval = ({
  gutterSize,
  buttonSize,
  onSubmit,
  defaultValue
}) => {
  const [customInterval, setCustomInterval] = (0, _react.useState)(defaultValue);
  const refreshInterval = (0, _time_interval.getTimeInterval)(customInterval);
  const isInvalid = Boolean(customInterval.length && !refreshInterval);
  const handleChange = ev => setCustomInterval(ev.target.value);
  return /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: ev => {
      ev.preventDefault();
      if (!isInvalid && refreshInterval) {
        onSubmit(refreshInterval);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 53,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: gutterSize,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getFormLabel(),
    helpText: strings.getFormDescription(),
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    isInvalid: isInvalid,
    value: customInterval,
    onChange: handleChange,
    compressed: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true,
    display: "rowCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: isInvalid,
    size: buttonSize,
    type: "submit",
    minWidth: "auto",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }, strings.getButtonLabel())))));
};
exports.CustomInterval = CustomInterval;
CustomInterval.propTypes = {
  buttonSize: _propTypes.default.string,
  gutterSize: _propTypes.default.string,
  defaultValue: _propTypes.default.string,
  onSubmit: _propTypes.default.func.isRequired
};
CustomInterval.defaultProps = {
  buttonSize: 's',
  gutterSize: 's',
  defaultValue: ''
};